/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.mixin.compat.appflux;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.PatternProviderMenu;
import java.util.Arrays;
import lu.kolja.expandedae.definition.ExpSettings;
import lu.kolja.expandedae.enums.BlockingMode;
import lu.kolja.expandedae.helper.misc.KeybindUtil;
import lu.kolja.expandedae.helper.pattern.IPatternProvider;
import lu.kolja.expandedae.helper.pattern.IUpgradableMenu;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PatternProviderMenu.class}, remap=false)
public abstract class AppFluxMixinPatternProviderMenu
extends AEBaseMenu
implements IUpgradableMenu,
IPatternProvider {
    @Unique
    private static final int BASE_FACTOR = 2;
    @Final
    @Shadow(remap=false)
    protected PatternProviderLogic logic;
    @Unique
    @GuiSync(value=8)
    public BlockingMode eae$blockingMode = BlockingMode.DEFAULT;

    public AppFluxMixinPatternProviderMenu(MenuType<?> menuType, int id, Inventory playerInventory, Object host) {
        super(menuType, id, playerInventory, host);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/MenuType;ILnet/minecraft/world/entity/player/Inventory;Lappeng/helpers/patternprovider/PatternProviderLogicHost;)V"}, at={@At(value="TAIL")}, remap=true)
    private void initToolbox(MenuType<?> menuType, int id, Inventory playerInventory, PatternProviderLogicHost host, CallbackInfo ci) {
        this.registerClientAction("modifyPatterns", Boolean.class, this::expandedae$modifyPatterns);
    }

    @Override
    @Unique
    public void expandedae$modifyPatterns(boolean rightClick) {
        if (this.isClientSide()) {
            this.sendClientAction("modifyPatterns", rightClick);
        }
        for (Slot slot : this.getSlots(SlotSemantics.ENCODED_PATTERN)) {
            ItemStack stack = slot.getItem();
            IPatternDetails detail = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().level());
            if (!(detail instanceof AEProcessingPattern)) continue;
            AEProcessingPattern processingPattern = (AEProcessingPattern)detail;
            GenericStack[] input = (GenericStack[])processingPattern.getSparseInputs().toArray(GenericStack[]::new);
            GenericStack[] output = (GenericStack[])processingPattern.getOutputs().toArray(GenericStack[]::new);
            if (!this.expandedae$checkModify(input, this.expandedae$getScale(), rightClick) || !this.expandedae$checkModify(output, this.expandedae$getScale(), rightClick)) continue;
            GenericStack[] mulInput = new GenericStack[input.length];
            GenericStack[] mulOutput = new GenericStack[output.length];
            this.expandedae$modifyStacks(input, mulInput, this.expandedae$getScale(), rightClick);
            this.expandedae$modifyStacks(output, mulOutput, this.expandedae$getScale(), rightClick);
            ItemStack newPattern = PatternDetailsHelper.encodeProcessingPattern(Arrays.stream(mulInput).toList(), Arrays.stream(mulOutput).toList());
            slot.set(newPattern);
        }
    }

    @Unique
    private int expandedae$getScale() {
        return 2 * KeybindUtil.shiftMultiplier() * KeybindUtil.ctrlMultiplier();
    }

    @Unique
    private boolean expandedae$checkModify(GenericStack[] stacks, int scale, boolean division) {
        if (division) {
            for (GenericStack stack : stacks) {
                if (stack == null || stack.amount() % (long)scale == 0L) continue;
                return false;
            }
        } else {
            for (GenericStack stack : stacks) {
                if (stack == null) continue;
                long upper = 999999L * (long)stack.what().getAmountPerUnit();
                if (stack.amount() * (long)scale <= upper) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    private void expandedae$modifyStacks(GenericStack[] stacks, GenericStack[] des, int scale, boolean division) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            long amt = division ? stacks[i].amount() / (long)scale : stacks[i].amount() * (long)scale;
            des[i] = new GenericStack(stacks[i].what(), amt);
        }
    }

    @Inject(method={"broadcastChanges"}, at={@At(value="INVOKE", target="Lappeng/helpers/patternprovider/PatternProviderLogic;getUnlockStack()Lappeng/api/stacks/GenericStack;", remap=false)})
    private void broadcastChanges(CallbackInfo ci) {
        this.eae$blockingMode = (BlockingMode)this.logic.getConfigManager().getSetting(ExpSettings.BLOCKING_MODE);
    }

    @Override
    public BlockingMode expandedae$getBlockingMode() {
        return this.eae$blockingMode;
    }
}

