/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.networking;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.util.ClientUtil;
import com.github.jarva.arsadditions.setup.networking.NetworkHandler;
import com.github.jarva.arsadditions.setup.registry.AddonAttachmentRegistry;
import com.hollingsworth.arsnouveau.ArsNouveau;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenNexusPacket(BlockPos pos, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenNexusPacket> TYPE = new CustomPacketPayload.Type(ArsAdditions.prefix("open_nexus"));
    public static final StreamCodec<ByteBuf, OpenNexusPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenNexusPacket::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, OpenNexusPacket::tag, OpenNexusPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleData(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = ArsNouveau.proxy.getPlayer();
            ItemStackHandler itemStackHandler = new ItemStackHandler(9);
            itemStackHandler.deserializeNBT((HolderLookup.Provider)player.registryAccess(), this.tag);
            ClientUtil.openWarpScreen(ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.pos), itemStackHandler);
        });
    }

    public static void openNexus(Player player, BlockPos pos) {
        ItemStackHandler nexus = (ItemStackHandler)player.getData(AddonAttachmentRegistry.WARP_NEXUS_INVENTORY);
        CompoundTag tag = nexus.serializeNBT((HolderLookup.Provider)player.registryAccess());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayerClient(new OpenNexusPacket(pos, tag), serverPlayer);
        }
    }
}

