/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ElectrolysisRecipe
extends MekanismRecipe<SingleFluidRecipeInput>
implements Predicate<FluidStack> {
    private static final Holder<Item> ELECTROLYTIC_SEPARATOR = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"electrolytic_separator"));

    public abstract FluidStackIngredient getInput();

    public abstract List<ElectrolysisRecipeOutput> getOutputDefinition();

    @Override
    public abstract boolean test(FluidStack var1);

    public boolean matches(SingleFluidRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.fluid());
    }

    @Contract(value="_ -> new", pure=true)
    public abstract ElectrolysisRecipeOutput getOutput(FluidStack var1);

    public abstract long getEnergyMultiplier();

    @Override
    public boolean isIncomplete() {
        return this.getInput().hasNoMatchingInstances();
    }

    @Override
    public void logMissingTags() {
        this.getInput().logMissingTags();
    }

    public final RecipeType<ElectrolysisRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_SEPARATING.value();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(ELECTROLYTIC_SEPARATOR);
    }

    public record ElectrolysisRecipeOutput(@NotNull ChemicalStack left, @NotNull ChemicalStack right) {
        public ElectrolysisRecipeOutput(@NotNull ChemicalStack left, @NotNull ChemicalStack right) {
            Objects.requireNonNull(left, "Left output cannot be null.");
            Objects.requireNonNull(right, "Right output cannot be null.");
            if (left.isEmpty()) {
                throw new IllegalArgumentException("Left output cannot be empty.");
            }
            if (right.isEmpty()) {
                throw new IllegalArgumentException("Right output cannot be empty.");
            }
        }
    }
}

