/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import java.util.List;
import mekanism.api.gear.config.IHasModeIcon;
import mekanism.api.gear.config.ModuleEnumConfig;
import mekanism.api.text.IHasTextComponent;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

class EnumToggle<TYPE extends Enum<TYPE>>
extends MiniElement<TYPE> {
    private static final ResourceLocation SLIDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "slider.png");
    private static final float TEXT_SCALE = 0.7f;
    private static final int BAR_START = 10;
    private final List<TYPE> enumConstants;
    private final int BAR_LENGTH = this.parent.getScreenWidth() - 24;
    private final int optionDistance;
    private final boolean usesIcons;
    boolean dragging = false;

    EnumToggle(GuiModuleScreen parent, ModuleEnumConfig<TYPE> data, Component description, int xPos, int yPos) {
        super(parent, data, description, xPos, yPos);
        this.enumConstants = data.getEnumConstants();
        this.optionDistance = this.BAR_LENGTH / (this.enumConstants.size() - 1);
        this.usesIcons = !this.enumConstants.isEmpty() && this.enumConstants.getFirst() instanceof IHasModeIcon;
    }

    @Override
    protected int getNeededHeight() {
        return this.usesIcons ? 31 : 28;
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
        guiGraphics.blit(SLIDER, this.getRelativeX() + 10 + center - 2, this.getRelativeY() + 11, 0.0f, 0.0f, 5, 6, 8, 8);
        guiGraphics.blit(SLIDER, this.getRelativeX() + 10, this.getRelativeY() + 17, 0.0f, 6.0f, this.BAR_LENGTH, 2, 8, 8);
    }

    @Override
    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        Component description = this.description;
        if (this.usesIcons) {
            description = MekanismLang.GENERIC_STORED.translate(description, this.data.get());
        }
        this.parent.drawScaledScrollingString(guiGraphics, description, this.xPos, this.yPos, IFancyFontRenderer.TextAlignment.LEFT, textColor, this.parent.getScreenWidth() - 6, 2, false, 0.8f);
        for (Enum option : this.enumConstants) {
            Component text = ((IHasTextComponent)((Object)option)).getTextComponent();
            int optionCenter = 10 + this.optionDistance * option.ordinal();
            int color = textColor;
            if (text.getStyle().getColor() != null) {
                color = 0xFF000000 | text.getStyle().getColor().getValue();
            }
            GuiUtils.fill(guiGraphics, this.getRelativeX() + optionCenter, this.getRelativeY() + 17, 1, 3, color);
            if (this.usesIcons) {
                IHasModeIcon hasModeIcon = (IHasModeIcon)((Object)option);
                guiGraphics.blit(hasModeIcon.getModeIcon(), this.getRelativeX() + optionCenter - 8, this.getRelativeY() + 19, 0.0f, 0.0f, 16, 16, 16, 16);
                continue;
            }
            int textWidth = this.parent.font().width((FormattedText)text);
            float objectWidth = (float)textWidth * 0.7f;
            if ((float)optionCenter < objectWidth / 2.0f) {
                this.parent.drawScaledScrollingString(guiGraphics, text, this.xPos, this.yPos + 20, IFancyFontRenderer.TextAlignment.CENTER, textColor, 10 + this.optionDistance / 2, 1, false, 0.7f);
                continue;
            }
            int max = this.parent.getScreenWidth() - 1;
            int start = this.xPos + optionCenter - this.optionDistance / 2;
            if (start + Mth.ceil((float)objectWidth) > max) {
                this.parent.drawScaledScrollingString(guiGraphics, text, start, this.yPos + 20, IFancyFontRenderer.TextAlignment.CENTER, textColor, max - start, 1, false, 0.7f);
                continue;
            }
            this.parent.drawScaledScrollingString(guiGraphics, text, start, this.yPos + 20, IFancyFontRenderer.TextAlignment.CENTER, textColor, this.optionDistance, 1, false, 0.7f);
        }
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (!this.dragging) {
            int center = this.optionDistance * ((Enum)this.data.get()).ordinal();
            if (this.mouseOver(mouseX, mouseY, 10 + center - 2, 11, 5, 6)) {
                this.dragging = true;
            } else if (this.mouseOver(mouseX, mouseY, 10, 10, this.BAR_LENGTH, 12)) {
                this.setDataFromPosition(mouseX);
            }
        }
    }

    @Override
    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setDataFromPosition(mouseX);
        }
    }

    private void setDataFromPosition(double mouseX) {
        List<TYPE> options = this.enumConstants;
        int size = options.size() - 1;
        int cur = (int)Math.round((mouseX - (double)this.getX() - 10.0) / (double)this.BAR_LENGTH * (double)size);
        if ((cur = Mth.clamp((int)cur, (int)0, (int)size)) != ((Enum)this.data.get()).ordinal()) {
            this.setData((Enum)options.get(cur));
        }
    }

    @Override
    protected void release(double mouseX, double mouseY) {
        this.dragging = false;
    }
}

