/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiRecipe;
import mekanism.client.recipe_viewer.recipe.BoilerRecipeViewerRecipe;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BoilerEmiRecipe
extends MekanismEmiRecipe<BoilerRecipeViewerRecipe> {
    public BoilerEmiRecipe(MekanismEmiRecipeCategory category, ResourceLocation id, BoilerRecipeViewerRecipe recipe) {
        super(category, id, recipe);
        this.addInputDefinition(recipe.water());
        this.addChemicalOutputDefinition(List.of(recipe.steam()));
        if (recipe.superHeatedCoolant() == null) {
            this.addEmptyInput();
            this.addOutputDefinition(Collections.emptyList());
        } else {
            this.addInputDefinition(recipe.superHeatedCoolant());
            this.addChemicalOutputDefinition(List.of(recipe.cooledCoolant()));
        }
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        this.addElement(widgetHolder, new GuiInnerScreen((IGuiWrapper)this, 48, 23, 96, 40, () -> List.of(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(((BoilerRecipeViewerRecipe)this.recipe).temperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.BOIL_RATE.translate(TextUtils.format(MathUtils.clampToInt(((BoilerRecipeViewerRecipe)this.recipe).steam().getAmount()))))));
        this.initTank(widgetHolder, GuiChemicalGauge.getDummy(GaugeType.STANDARD, this, 6, 13).setLabel((Component)MekanismLang.BOILER_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE)), this.input(1));
        this.initTank(widgetHolder, GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 26, 13).setLabel((Component)MekanismLang.BOILER_WATER_TANK.translateColored(EnumColor.INDIGO)), this.input(0));
        this.initTank(widgetHolder, GuiChemicalGauge.getDummy(GaugeType.STANDARD, this, 148, 13).setLabel((Component)MekanismLang.BOILER_STEAM_TANK.translateColored(EnumColor.GRAY)), this.output(0)).recipeContext((EmiRecipe)this);
        this.initTank(widgetHolder, GuiChemicalGauge.getDummy(GaugeType.STANDARD, this, 168, 13).setLabel((Component)MekanismLang.BOILER_COOLANT_TANK.translateColored(EnumColor.AQUA)), this.output(1)).recipeContext((EmiRecipe)this);
    }
}

