/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMaps;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIODriveData;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.InsertableSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import org.jetbrains.annotations.Nullable;

public class QIOServerCraftingTransferHandler {
    private final QIOCraftingWindow craftingWindow;
    private final ResourceLocation recipeID;
    private final Player player;
    @Nullable
    private final QIOFrequency frequency;
    private final boolean rejectToInventory;
    private final List<HotBarSlot> hotBarSlots;
    private final List<MainInventorySlot> mainInventorySlots;
    private final Byte2ObjectMap<SlotData> availableItems = new Byte2ObjectOpenHashMap();
    private final Map<UUID, FrequencySlotData> frequencyAvailableItems = new HashMap<UUID, FrequencySlotData>();
    private final NonNullList<ItemStack> recipeToTest = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);

    public static void tryTransfer(QIOItemViewerContainer container, byte selectedCraftingGrid, boolean rejectToInventory, Player player, ResourceLocation recipeID, CraftingRecipe recipe, Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) {
        QIOServerCraftingTransferHandler transferHandler = new QIOServerCraftingTransferHandler(container, selectedCraftingGrid, rejectToInventory, player, recipeID);
        transferHandler.tryTransfer(recipe, sources);
    }

    private QIOServerCraftingTransferHandler(QIOItemViewerContainer container, byte selectedCraftingGrid, boolean rejectToInventory, Player player, ResourceLocation recipeID) {
        this.player = player;
        this.recipeID = recipeID;
        this.frequency = container.getFrequency();
        this.rejectToInventory = rejectToInventory;
        this.craftingWindow = container.getCraftingWindow(selectedCraftingGrid);
        this.hotBarSlots = container.getHotBarSlots();
        this.mainInventorySlots = container.getMainInventorySlots();
    }

    private void tryTransfer(CraftingRecipe recipe, Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) {
        for (byte slot = 0; slot < 9; slot = (byte)((byte)(slot + 1))) {
            IInventorySlot inputSlot = this.craftingWindow.getInputSlot(slot);
            if (inputSlot.isEmpty()) continue;
            ItemStack available = inputSlot.extractItem(inputSlot.getCount(), Action.SIMULATE, AutomationType.INTERNAL);
            if (available.getCount() < inputSlot.getCount()) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, and was unable to extract all items from crafting input slot: {}.", new Object[]{this.player, this.recipeID, slot});
                return;
            }
            this.availableItems.put(slot, (Object)new SlotData(available));
        }
        ObjectIterator iterator = Byte2ObjectMaps.fastIterator(sources);
        while (iterator.hasNext()) {
            Byte2ObjectMap.Entry entry = (Byte2ObjectMap.Entry)iterator.next();
            byte targetSlot = entry.getByteKey();
            if (targetSlot < 0 || targetSlot >= 9) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, with an invalid target slot id: {}.", new Object[]{this.player, this.recipeID, targetSlot});
                return;
            }
            int stackSize = 0;
            List singleSources = (List)entry.getValue();
            Iterator iter = singleSources.iterator();
            while (iter.hasNext()) {
                QIOCraftingTransferHelper.SingularHashedItemSource source = (QIOCraftingTransferHelper.SingularHashedItemSource)iter.next();
                byte slot = source.getSlot();
                int used = slot == -1 ? this.simulateQIOSource(targetSlot, source.getQioSource(), source.getUsed(), stackSize) : this.simulateSlotSource(targetSlot, slot, source.getUsed(), stackSize);
                if (used == -1) {
                    return;
                }
                if (used == 0) {
                    iter.remove();
                    continue;
                }
                if (used < source.getUsed()) {
                    source.setUsed(used);
                }
                stackSize += used;
            }
            if (singleSources.isEmpty()) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, that had no valid sources, this should not be possible.", (Object)this.player, (Object)this.recipeID);
                return;
            }
            ItemStack resultItem = (ItemStack)this.recipeToTest.get((int)targetSlot);
            if (resultItem.isEmpty() || resultItem.getMaxStackSize() >= stackSize) continue;
            Mekanism.logger.warn("Received transfer request from: {}, for: {}, that tried to transfer more items into: {} than can stack ({}) in one slot.", new Object[]{this.player, this.recipeID, targetSlot, resultItem.getMaxStackSize()});
            return;
        }
        CraftingInput dummy = MekanismUtils.getCraftingInput(3, 3, this.recipeToTest, true).input();
        if (!recipe.matches((RecipeInput)dummy, this.player.level())) {
            Mekanism.logger.warn("Received transfer request from: {}, but source items aren't valid for the requested recipe: {}.", (Object)this.player, (Object)this.recipeID);
        } else if (!this.hasRoomToShuffle()) {
            Mekanism.logger.debug("Received transfer request from: {}, but there is not enough room to shuffle items around for the requested recipe: {}.", (Object)this.player, (Object)this.recipeID);
        } else {
            this.transferItems(sources);
        }
    }

    private int simulateQIOSource(byte targetSlot, UUID qioSource, int used, int currentStackSize) {
        if (qioSource == null) {
            return this.fail("Received transfer request from: {}, for: {}, with no valid source.", this.player, this.recipeID);
        }
        FrequencySlotData slotData = this.frequencyAvailableItems.get(qioSource);
        if (slotData == null) {
            if (this.frequency == null) {
                return this.fail("Received transfer request from: {}, for: {}, with a QIO source but no selected frequency.", this.player, this.recipeID);
            }
            HashedItem storedItem = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(qioSource);
            if (storedItem == null) {
                return this.fail("Received transfer request from: {}, for: {}, for item with unknown UUID: {}.", this.player, this.recipeID, qioSource);
            }
            long stored = this.frequency.getStoredByHash(storedItem);
            slotData = stored == 0L ? FrequencySlotData.EMPTY : new FrequencySlotData(storedItem, stored);
            this.frequencyAvailableItems.put(qioSource, slotData);
        }
        return this.addStackToRecipe(targetSlot, slotData, used, (byte)-1, currentStackSize);
    }

    private int simulateSlotSource(byte targetSlot, byte slot, int used, int currentStackSize) {
        if (slot < 0 || slot >= 9 + Inventory.getSelectionSize() + 27) {
            return this.fail("Received transfer request from: {}, for: {}, with an invalid slot id: {}.", this.player, this.recipeID, slot);
        }
        SlotData slotData = (SlotData)this.availableItems.get(slot);
        if (slotData == null) {
            InsertableSlot inventorySlot;
            if (slot < 9) {
                return this.fail("Received transfer request from: {}, for: {}, with a request to take from crafting window slot: {}, but that slot cannot be taken from.", this.player, this.recipeID, slot);
            }
            if (slot < 9 + Inventory.getSelectionSize()) {
                int actualSlot = slot - 9;
                if (actualSlot >= this.hotBarSlots.size()) {
                    return this.fail("Received transfer request from: {}, for: {}, could not find hotbar slot: {}.", this.player, this.recipeID, actualSlot);
                }
                inventorySlot = this.hotBarSlots.get(actualSlot);
                if (!inventorySlot.mayPickup(this.player)) {
                    return this.fail("Received transfer request from: {}, for: {}, with a request to take from hotbar slot: {}, but that slot cannot be taken from.", this.player, this.recipeID, actualSlot);
                }
            } else {
                int actualSlot = slot - 9 - Inventory.getSelectionSize();
                if (actualSlot >= this.mainInventorySlots.size()) {
                    return this.fail("Received transfer request from: {}, for: {}, could not find main inventory slot: {}.", this.player, this.recipeID, actualSlot);
                }
                inventorySlot = this.mainInventorySlots.get(actualSlot);
                if (!inventorySlot.mayPickup(this.player)) {
                    return this.fail("Received transfer request from: {}, for: {}, with a request to take from main inventory slot: {}, but that slot cannot be taken from.", this.player, this.recipeID, actualSlot);
                }
            }
            slotData = inventorySlot.hasItem() ? new SlotData(inventorySlot.getItem()) : SlotData.EMPTY;
            this.availableItems.put(slot, (Object)slotData);
        }
        return this.addStackToRecipe(targetSlot, slotData, used, slot, currentStackSize);
    }

    private int addStackToRecipe(byte targetSlot, ItemData slotData, int used, byte sourceSlot, int currentStackSize) {
        if (slotData.isEmpty()) {
            if (sourceSlot == -1) {
                return this.fail("Received transfer request from: {}, for: {}, for an item that isn't stored in the frequency.", this.player, this.recipeID);
            }
            return this.fail("Received transfer request from: {}, for: {}, for an empty slot: {}.", this.player, this.recipeID, sourceSlot);
        }
        if (slotData.getAvailable() < used) {
            if (sourceSlot == -1) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, but the QIO frequency only had {} remaining items instead of the expected: {}. Attempting to continue by only using the available number of items.", new Object[]{this.player, this.recipeID, slotData.getAvailable(), used});
            } else {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, but slot: {} only had {} remaining items instead of the expected: {}. Attempting to continue by only using the available number of items.", new Object[]{this.player, this.recipeID, sourceSlot, slotData.getAvailable(), used});
            }
            used = slotData.getAvailable();
        }
        ItemStack currentRecipeTarget = (ItemStack)this.recipeToTest.get((int)targetSlot);
        ItemStack slotStack = slotData.getStack();
        if (currentRecipeTarget.isEmpty()) {
            int max = slotStack.getMaxStackSize();
            if (used > max) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, but the item being moved can only stack to: {} but a stack of size: {} was being moved. Attempting to continue by only using as many items as can be stacked.", new Object[]{this.player, this.recipeID, max, used});
                used = max;
            }
            this.recipeToTest.set((int)targetSlot, (Object)slotStack.copy());
        } else {
            if (!ItemStack.isSameItemSameComponents((ItemStack)currentRecipeTarget, (ItemStack)slotStack)) {
                Mekanism.logger.debug("Received transfer request from: {}, for: {}, but found items for target slot: {} cannot stack. Attempting to continue by skipping the additional stack.", new Object[]{this.player, this.recipeID, targetSlot});
                return 0;
            }
            int max = currentRecipeTarget.getMaxStackSize();
            int needed = max - currentStackSize;
            if (used > needed) {
                Mekanism.logger.warn("Received transfer request from: {}, for: {}, but moving the requested amount of: {} would cause the output stack to past its max stack size ({}). Attempting to continue by only using as many items as can be stacked.", new Object[]{this.player, this.recipeID, used, max});
                used = needed;
            }
        }
        slotData.simulateUse(used);
        return used;
    }

    private boolean hasRoomToShuffle() {
        Object2IntArrayMap leftOverInput = new Object2IntArrayMap(9);
        for (byte inputSlot = 0; inputSlot < 9; inputSlot = (byte)(inputSlot + 1)) {
            SlotData inputSlotData = (SlotData)this.availableItems.get(inputSlot);
            if (inputSlotData == null || inputSlotData.getAvailable() <= 0) continue;
            leftOverInput.mergeInt((Object)HashedItem.raw(inputSlotData.getStack()), inputSlotData.getAvailable(), Integer::sum);
        }
        if (!leftOverInput.isEmpty()) {
            QIOCraftingTransferHelper.BaseSimulatedInventory simulatedInventory = new QIOCraftingTransferHelper.BaseSimulatedInventory(this.hotBarSlots, this.mainInventorySlots){

                @Override
                protected int getRemaining(int slot, ItemStack currentStored) {
                    SlotData slotData = (SlotData)QIOServerCraftingTransferHandler.this.availableItems.get((byte)(slot + 9));
                    return slotData == null ? currentStored.getCount() : slotData.getAvailable();
                }
            };
            Object2IntMap<HashedItem> stillLeftOver = simulatedInventory.shuffleInputs((Object2IntMap<HashedItem>)leftOverInput, this.frequency != null);
            if (stillLeftOver == null) {
                return false;
            }
            if (!stillLeftOver.isEmpty() && this.frequency != null) {
                int availableItemTypes = this.frequency.getTotalItemTypeCapacity() - this.frequency.getTotalItemTypes(false);
                long availableItemSpace = this.frequency.getTotalItemCountCapacity() - this.frequency.getTotalItemCount();
                for (FrequencySlotData slotData : this.frequencyAvailableItems.values()) {
                    availableItemSpace += (long)slotData.getUsed();
                    if (slotData.getAvailable() != 0) continue;
                    ++availableItemTypes;
                }
                ObjectIterator iterator = Object2IntMaps.fastIterator(stillLeftOver);
                while (iterator.hasNext()) {
                    FrequencySlotData frequencySlotData;
                    Object uuid;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    if ((availableItemSpace -= (long)entry.getIntValue()) <= 0L) {
                        return false;
                    }
                    if (!(this.frequency.isStoring((HashedItem)entry.getKey()) ? (uuid = QIOGlobalItemLookup.INSTANCE.getUUIDForType((HashedItem)entry.getKey())) != null && (frequencySlotData = this.frequencyAvailableItems.get(uuid)) != null && frequencySlotData.getAvailable() == 0 && --availableItemTypes <= 0 : --availableItemTypes <= 0)) continue;
                    return false;
                }
                Collection<QIODriveData> drives = this.frequency.getAllDrives();
                ArrayList<SimulatedQIODrive> simulatedDrives = new ArrayList<SimulatedQIODrive>(drives.size());
                for (QIODriveData qIODriveData : drives) {
                    simulatedDrives.add(new SimulatedQIODrive(qIODriveData));
                }
                for (Map.Entry entry : this.frequencyAvailableItems.entrySet()) {
                    SimulatedQIODrive drive;
                    FrequencySlotData slotData = (FrequencySlotData)entry.getValue();
                    HashedItem type = slotData.getType();
                    if (type == null) continue;
                    int toRemove = slotData.getUsed();
                    Iterator iterator2 = simulatedDrives.iterator();
                    while (iterator2.hasNext() && (toRemove = (drive = (SimulatedQIODrive)iterator2.next()).remove(type, toRemove)) != 0) {
                    }
                }
                ObjectIterator iterator3 = Object2IntMaps.fastIterator(stillLeftOver);
                while (iterator3.hasNext()) {
                    SimulatedQIODrive drive;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator3.next();
                    HashedItem item = (HashedItem)entry.getKey();
                    int toAdd = entry.getIntValue();
                    Iterator iterator4 = simulatedDrives.iterator();
                    while (iterator4.hasNext() && (toAdd = (drive = (SimulatedQIODrive)iterator4.next()).add(item, toAdd, true)) != 0) {
                    }
                    if (toAdd <= 0) continue;
                    iterator4 = simulatedDrives.iterator();
                    while (iterator4.hasNext() && (toAdd = (drive = (SimulatedQIODrive)iterator4.next()).add(item, toAdd, false)) != 0) {
                    }
                    if (toAdd <= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void transferItems(Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) {
        Byte2ObjectMap.Entry entry;
        SelectedWindowData windowData = this.craftingWindow.getWindowData();
        Byte2ObjectArrayMap targetContents = new Byte2ObjectArrayMap(sources.size());
        ObjectIterator iterator = Byte2ObjectMaps.fastIterator(sources);
        while (iterator.hasNext()) {
            Byte2ObjectMap.Entry entry2 = (Byte2ObjectMap.Entry)iterator.next();
            for (QIOCraftingTransferHelper.SingularHashedItemSource source : (List)entry2.getValue()) {
                ItemStack stack;
                int slot = source.getSlot();
                if (slot == -1) {
                    UUID qioSource = source.getQioSource();
                    HashedItem storedItem = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(qioSource);
                    if (storedItem == null) {
                        this.bail((Byte2ObjectMap<ItemStack>)targetContents, "Received transfer request from: {}, for: {}, for item with unknown UUID: {}.", this.player, this.recipeID, qioSource);
                        return;
                    }
                    if (!this.frequency.isStoring(storedItem)) {
                        this.bail((Byte2ObjectMap<ItemStack>)targetContents, "Received transfer request from: {}, for: {}, could not find stored item with UUID: {}. This likely means that more of it was requested than is stored.", this.player, this.recipeID, qioSource);
                        return;
                    }
                    stack = this.frequency.removeByType(storedItem, source.getUsed());
                    if (stack.isEmpty()) {
                        this.bail((Byte2ObjectMap<ItemStack>)targetContents, "Received transfer request from: {}, for: {}, but could not extract item: {} from the QIO.", this.player, this.recipeID, storedItem);
                        return;
                    }
                    if (stack.getCount() < source.getUsed()) {
                        Mekanism.logger.warn("Received transfer request from: {}, for: {}, but was unable to extract the expected amount: {} of item: {} from the QIO. This should not be possible as it should have been caught during simulation. Attempting to continue anyways with the actual extracted amount of {}.", new Object[]{this.player, this.recipeID, source.getUsed(), storedItem, stack.getCount()});
                    }
                } else {
                    String slotType;
                    int actualSlot;
                    if (slot < 9) {
                        actualSlot = slot;
                        slotType = "crafting window";
                        stack = this.craftingWindow.getInputSlot(slot).extractItem(source.getUsed(), Action.EXECUTE, AutomationType.MANUAL);
                    } else if (slot < 9 + Inventory.getSelectionSize()) {
                        actualSlot = slot - 9;
                        slotType = "hotbar";
                        stack = this.hotBarSlots.get(actualSlot).remove(source.getUsed());
                    } else {
                        actualSlot = slot - 9 - Inventory.getSelectionSize();
                        slotType = "main inventory";
                        stack = this.mainInventorySlots.get(actualSlot).remove(source.getUsed());
                    }
                    if (stack.isEmpty()) {
                        this.bail((Byte2ObjectMap<ItemStack>)targetContents, "Received transfer request from: {}, for: {}, could not extract item from {} slot: {}. This likely means that more of it was requested than is stored.", this.player, this.recipeID, slotType, actualSlot);
                        return;
                    }
                    if (stack.getCount() < source.getUsed()) {
                        Mekanism.logger.warn("Received transfer request from: {}, for: {}, but was unable to extract the expected amount: {} from {} slot: {}. This should not be possible as it should have been caught during simulation. Attempting to continue anyways with the actual extracted amount of {}.", new Object[]{this.player, this.recipeID, source.getUsed(), slotType, actualSlot, stack.getCount()});
                    }
                }
                byte targetSlot = entry2.getByteKey();
                if (targetContents.containsKey(targetSlot)) {
                    ItemStack existing = (ItemStack)targetContents.get(targetSlot);
                    if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
                        int needed = existing.getMaxStackSize() - existing.getCount();
                        if (stack.getCount() <= needed) {
                            existing.grow(stack.getCount());
                            continue;
                        }
                        existing.grow(needed);
                        stack.shrink(needed);
                        Mekanism.logger.warn("Received transfer request from: {}, for: {}, but contents could not fully fit into target slot: {}. This should not be able to happen, returning excess stack, and attempting to continue.", new Object[]{this.player, this.recipeID, targetSlot});
                        this.returnItem(stack, windowData);
                        continue;
                    }
                    Mekanism.logger.warn("Received transfer request from: {}, for: {}, but contents could not stack into target slot: {}. This should not be able to happen, returning extra stack, and attempting to continue.", new Object[]{this.player, this.recipeID, targetSlot});
                    this.returnItem(stack, windowData);
                    continue;
                }
                targetContents.put(targetSlot, (Object)stack);
            }
        }
        Byte2ObjectArrayMap remainingCraftingGridContents = new Byte2ObjectArrayMap(9);
        for (byte slot = 0; slot < 9; slot = (byte)((byte)(slot + 1))) {
            IInventorySlot inputSlot = this.craftingWindow.getInputSlot(slot);
            if (inputSlot.isEmpty()) continue;
            ItemStack stack = inputSlot.extractItem(inputSlot.getCount(), Action.EXECUTE, AutomationType.MANUAL);
            if (!stack.isEmpty()) {
                remainingCraftingGridContents.put(slot, (Object)stack);
                continue;
            }
            this.bail((Byte2ObjectMap<ItemStack>)targetContents, (Byte2ObjectMap<ItemStack>)remainingCraftingGridContents, "Received transfer request from: {}, for: {}, but failed to remove items from crafting input slot: {}. This should not be possible as it should have been caught by an earlier check.", this.player, this.recipeID, slot);
            return;
        }
        ObjectIterator iterator2 = Byte2ObjectMaps.fastIterator((Byte2ObjectMap)targetContents);
        while (iterator2.hasNext()) {
            entry = (Byte2ObjectMap.Entry)iterator2.next();
            byte targetSlot = entry.getByteKey();
            IInventorySlot inputSlot = this.craftingWindow.getInputSlot(targetSlot);
            ItemStack remainder = inputSlot.insertItem((ItemStack)entry.getValue(), Action.EXECUTE, AutomationType.MANUAL);
            if (remainder.isEmpty()) {
                iterator2.remove();
                continue;
            }
            targetContents.put(targetSlot, (Object)remainder);
            Mekanism.logger.warn("Received transfer request from: {}, for: {}, but was unable to fully insert it into the {} crafting input slot. This should not be possible as it should have been caught during simulation. Attempting to continue anyways.", new Object[]{this.player, this.recipeID, targetSlot});
        }
        iterator2 = Byte2ObjectMaps.fastIterator((Byte2ObjectMap)remainingCraftingGridContents);
        while (iterator2.hasNext()) {
            entry = (Byte2ObjectMap.Entry)iterator2.next();
            ItemStack stack = (ItemStack)entry.getValue();
            if (this.rejectToInventory) {
                stack = this.returnItemToInventory(stack, windowData);
            }
            if (stack.isEmpty()) continue;
            IInventorySlot inputSlot = this.craftingWindow.getInputSlot(entry.getByteKey());
            if (ItemStack.isSameItemSameComponents((ItemStack)inputSlot.getStack(), (ItemStack)stack)) {
                stack = inputSlot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL);
            }
            if (stack.isEmpty()) continue;
            if (this.frequency != null) {
                stack = this.frequency.addItem(stack);
            }
            if (!this.rejectToInventory) {
                stack = this.returnItemToInventory(stack, windowData);
            }
            if (stack.isEmpty()) continue;
            this.player.drop(stack, false);
            Mekanism.logger.warn("Received transfer request from: {}, for: {}, initially targeting the player's inventory: {}, and was unable to fit all contents that were in the crafting window into the player's inventory/QIO system; dropping items by player.", new Object[]{this.player, this.recipeID, this.rejectToInventory});
        }
        if (!targetContents.isEmpty()) {
            this.bail((Byte2ObjectMap<ItemStack>)targetContents, "Received transfer request from: {}, for: {}, but ended up with {} items that could not be transferred into the proper crafting grid slot. This should not be possible as it should have been caught during simulation.", this.player, this.recipeID, targetContents.size());
        }
    }

    private void bail(Byte2ObjectMap<ItemStack> targetContents, String format, Object ... args) {
        this.bail(targetContents, (Byte2ObjectMap<ItemStack>)Byte2ObjectMaps.emptyMap(), format, args);
    }

    private void bail(Byte2ObjectMap<ItemStack> targetContents, Byte2ObjectMap<ItemStack> remainingCraftingGridContents, String format, Object ... args) {
        Mekanism.logger.warn(format, args);
        SelectedWindowData windowData = this.craftingWindow.getWindowData();
        for (ItemStack stack : targetContents.values()) {
            this.returnItem(stack, windowData);
        }
        ObjectIterator iterator = Byte2ObjectMaps.fastIterator(remainingCraftingGridContents);
        while (iterator.hasNext()) {
            Byte2ObjectMap.Entry entry = (Byte2ObjectMap.Entry)iterator.next();
            ItemStack stack = (ItemStack)entry.getValue();
            IInventorySlot inputSlot = this.craftingWindow.getInputSlot(entry.getByteKey());
            if (ItemStack.isSameItemSameComponents((ItemStack)inputSlot.getStack(), (ItemStack)stack) && (stack = inputSlot.insertItem(stack, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) continue;
            this.returnItem(stack, windowData);
        }
    }

    private void returnItem(ItemStack stack, @Nullable SelectedWindowData windowData) {
        if (!(stack = this.returnItemToInventory(stack, windowData)).isEmpty()) {
            if (this.frequency != null) {
                stack = this.frequency.addItem(stack);
            }
            if (!stack.isEmpty()) {
                this.player.drop(stack, false);
            }
        }
    }

    private ItemStack returnItemToInventory(ItemStack stack, @Nullable SelectedWindowData windowData) {
        stack = MekanismContainer.insertItem(this.hotBarSlots, stack, true, windowData);
        stack = MekanismContainer.insertItem(this.mainInventorySlots, stack, true, windowData);
        stack = MekanismContainer.insertItem(this.hotBarSlots, stack, false, windowData);
        return MekanismContainer.insertItem(this.mainInventorySlots, stack, false, windowData);
    }

    private int fail(String format, Object ... args) {
        Mekanism.logger.warn(format, args);
        return -1;
    }

    private static class SlotData
    extends ItemData {
        public static final SlotData EMPTY = new SlotData(ItemStack.EMPTY, 0);
        private final ItemStack stack;

        public SlotData(ItemStack stack) {
            this(stack, stack.getCount());
        }

        protected SlotData(ItemStack stack, int available) {
            super(available);
            this.stack = stack;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY || this.stack.isEmpty();
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }
    }

    private static class FrequencySlotData
    extends ItemData {
        public static final FrequencySlotData EMPTY = new FrequencySlotData(null, 0L);
        private final HashedItem type;
        private int used;

        public FrequencySlotData(HashedItem type, long stored) {
            super(MathUtils.clampToInt(stored));
            this.type = type;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY || this.type == null;
        }

        @Override
        public ItemStack getStack() {
            return this.type == null ? ItemStack.EMPTY : this.type.getInternalStack();
        }

        @Override
        public void simulateUse(int used) {
            super.simulateUse(used);
            this.used += used;
        }

        public int getUsed() {
            return this.used;
        }

        public HashedItem getType() {
            return this.type;
        }
    }

    private static abstract class ItemData {
        private int available;

        protected ItemData(int available) {
            this.available = available;
        }

        public abstract boolean isEmpty();

        public int getAvailable() {
            return this.available;
        }

        public void simulateUse(int used) {
            this.available -= used;
        }

        protected abstract ItemStack getStack();
    }

    private static class SimulatedQIODrive {
        private final Object2LongMap<HashedItem> sourceItemMap;
        private Set<HashedItem> removedTypes;
        private int availableItemTypes;
        private long availableItemSpace;

        public SimulatedQIODrive(QIODriveData sourceDrive) {
            this.sourceItemMap = sourceDrive.getItemMap();
            this.availableItemSpace = sourceDrive.getCountCapacity() - sourceDrive.getTotalCount();
            this.availableItemTypes = sourceDrive.getTypeCapacity() - sourceDrive.getTotalTypes();
        }

        public int remove(HashedItem item, int count) {
            long stored = this.sourceItemMap.getOrDefault((Object)item, 0L);
            if (stored == 0L) {
                return count;
            }
            if (stored <= (long)count) {
                if (this.removedTypes == null) {
                    this.removedTypes = new HashSet<HashedItem>();
                }
                this.removedTypes.add(item);
                ++this.availableItemTypes;
                this.availableItemSpace += stored;
                return count - (int)stored;
            }
            this.availableItemSpace += (long)count;
            return 0;
        }

        public int add(HashedItem item, int count, boolean mustContain) {
            boolean contains;
            if (this.availableItemSpace == 0L) {
                return count;
            }
            boolean bl = contains = this.sourceItemMap.containsKey((Object)item) && (this.removedTypes == null || !this.removedTypes.contains(item));
            if (mustContain != contains) {
                return count;
            }
            if (!contains) {
                if (this.availableItemTypes == 0) {
                    return count;
                }
                --this.availableItemTypes;
            }
            if ((long)count < this.availableItemSpace) {
                this.availableItemSpace -= (long)count;
                return 0;
            }
            this.availableItemSpace = 0L;
            return count -= (int)this.availableItemSpace;
        }
    }
}

