/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IUpgradeTile;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBoundingBlock
extends TileEntityUpdateable
implements IUpgradeTile,
Nameable {
    @Nullable
    private BlockPos mainPos;
    private int currentRedstoneLevel;

    public TileEntityBoundingBlock(BlockPos pos, BlockState state) {
        super(MekanismTileEntityTypes.BOUNDING_BLOCK, pos, state);
    }

    public void setMainLocation(@Nullable BlockPos pos, boolean sync) {
        this.mainPos = pos;
        if (sync && !this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    public boolean canRedirectFrom(BlockPos boundingPos) {
        return this.mainPos != null && !this.mainPos.equals((Object)boundingPos);
    }

    public BlockPos getMainPos() {
        if (this.mainPos == null) {
            return this.worldPosition;
        }
        return this.mainPos;
    }

    @Nullable
    public BlockEntity getMainTile(BlockPos boundingPos) {
        return this.canRedirectFrom(boundingPos) ? WorldUtils.getTileEntity((BlockGetter)this.level, this.getMainPos()) : null;
    }

    @Nullable
    private IBoundingBlock getMain() {
        BlockEntity tile = this.getMainTile(this.worldPosition);
        if (tile != null && !(tile instanceof IBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IBoundingBlock, at {} in {}. Multiblock cannot function", new Object[]{tile, this.getMainPos(), this.level == null ? "null" : this.level.dimension().location()});
            return null;
        }
        return (IBoundingBlock)tile;
    }

    public boolean triggerEvent(int id, int param) {
        boolean handled = super.triggerEvent(id, param);
        IBoundingBlock main = this.getMain();
        return main != null && main.triggerBoundingEvent((Vec3i)this.worldPosition.subtract((Vec3i)this.getMainPos()), id, param) || handled;
    }

    public void onNeighborChange(Level level, Block block, BlockPos neighborPos) {
        int power;
        if (!this.isRemote() && this.currentRedstoneLevel != (power = level.getBestNeighborSignal(this.getBlockPos()))) {
            IBoundingBlock main = this.getMain();
            if (main != null) {
                main.onBoundingBlockPowerChange(this.worldPosition, this.currentRedstoneLevel, power);
            }
            this.currentRedstoneLevel = power;
        }
    }

    public int getComparatorSignal() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsComparator()) {
            return main.getBoundingComparatorSignal((Vec3i)this.worldPosition.subtract((Vec3i)this.getMainPos()));
        }
        return 0;
    }

    @Override
    public boolean supportsUpgrades() {
        IBoundingBlock main = this.getMain();
        return main != null && main.supportsUpgrades();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            return main.getComponent();
        }
        return null;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgradeType) {
        IBoundingBlock main = this.getMain();
        if (main != null && main.supportsUpgrades()) {
            main.recalculateUpgrades(upgradeType);
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        NBTUtils.setBlockPosIfPresent(nbt, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = nbt.getInt("redstone");
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        if (this.mainPos != null) {
            nbtTags.put("main", NbtUtils.writeBlockPos((BlockPos)this.mainPos));
        }
        nbtTags.putInt("redstone", this.currentRedstoneLevel);
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        if (this.mainPos != null) {
            updateTag.put("main", NbtUtils.writeBlockPos((BlockPos)this.mainPos));
        }
        updateTag.putInt("redstone", this.currentRedstoneLevel);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setBlockPosIfPresent(tag, "main", pos -> {
            this.mainPos = pos;
        });
        this.currentRedstoneLevel = tag.getInt("redstone");
    }

    public boolean hasCustomName() {
        Nameable mainTile;
        BlockEntity blockEntity = this.getMainTile(this.worldPosition);
        return blockEntity instanceof Nameable && (mainTile = (Nameable)blockEntity).hasCustomName();
    }

    @NotNull
    public Component getName() {
        Nameable mainTile;
        BlockEntity blockEntity = this.getMainTile(this.worldPosition);
        if (blockEntity instanceof Nameable && (mainTile = (Nameable)blockEntity).hasCustomName()) {
            return mainTile.getCustomName();
        }
        return MekanismBlocks.BOUNDING_BLOCK.getTextComponent();
    }

    @NotNull
    public Component getDisplayName() {
        Component component;
        BlockEntity blockEntity = this.getMainTile(this.worldPosition);
        if (blockEntity instanceof Nameable) {
            Nameable mainTile = (Nameable)blockEntity;
            component = mainTile.getDisplayName();
        } else {
            component = MekanismBlocks.BOUNDING_BLOCK.getTextComponent();
        }
        return component;
    }

    @Nullable
    public Component getCustomName() {
        Component component;
        BlockEntity blockEntity = this.getMainTile(this.worldPosition);
        if (blockEntity instanceof Nameable) {
            Nameable mainTile = (Nameable)blockEntity;
            component = mainTile.getCustomName();
        } else {
            component = null;
        }
        return component;
    }

    public static <CAP> void proxyCapability(RegisterCapabilitiesEvent event, BlockCapability<CAP, @Nullable Direction> capability) {
        event.registerBlock(capability, (level, pos, state, blockEntity, context) -> {
            TileEntityBoundingBlock bounding;
            IBoundingBlock main;
            if (blockEntity instanceof TileEntityBoundingBlock && (main = (bounding = (TileEntityBoundingBlock)blockEntity).getMain()) != null) {
                return main.getOffsetCapability(capability, (Direction)context, (Vec3i)pos.subtract((Vec3i)bounding.getMainPos()));
            }
            return null;
        }, new Block[]{(Block)MekanismBlocks.BOUNDING_BLOCK.value()});
    }

    public static <CAP, CONTEXT> void alwaysProxyCapability(RegisterCapabilitiesEvent event, BlockCapability<CAP, CONTEXT> capability) {
        event.registerBlock(capability, (level, pos, state, boundingBlock, context) -> {
            TileEntityBoundingBlock bounding;
            if (boundingBlock instanceof TileEntityBoundingBlock && (bounding = (TileEntityBoundingBlock)boundingBlock).canRedirectFrom(pos)) {
                return WorldUtils.getCapability(level, capability, bounding.getMainPos(), context);
            }
            return null;
        }, new Block[]{(Block)MekanismBlocks.BOUNDING_BLOCK.value()});
    }
}

