/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.data;

import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.shynieke.georenouveau.item.GeOreDowsingRod;
import com.shynieke.georenouveau.item.GeOreGolemCharm;
import com.shynieke.georenouveau.registry.CompatRegistry;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GNDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput, lookupProvider));
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(CompatEntityLoot::new, LootContextParamSets.ENTITY)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class CompatEntityLoot
        extends EntityLootSubProvider {
            protected CompatEntityLoot(HolderLookup.Provider provider) {
                super(FeatureFlags.REGISTRY.allFlags(), provider);
            }

            public void generate() {
                this.add(CompatRegistry.GEORE_GOLEM.get(), LootTable.lootTable());
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return CompatRegistry.ENTITY_TYPES.getEntries().stream().map(DeferredHolder::value);
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput output) {
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.COAL_GEORE_DOWSING_ROD, (ItemLike)Items.COAL, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.COPPER_GEORE_DOWSING_ROD, (ItemLike)Items.COPPER_INGOT, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.DIAMOND_GEORE_DOWSING_ROD, (ItemLike)Items.DIAMOND, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.EMERALD_GEORE_DOWSING_ROD, (ItemLike)Items.EMERALD, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.GOLD_GEORE_DOWSING_ROD, (ItemLike)Items.GOLD_INGOT, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.IRON_GEORE_DOWSING_ROD, (ItemLike)Items.IRON_INGOT, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.LAPIS_GEORE_DOWSING_ROD, (ItemLike)Items.LAPIS_LAZULI, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.QUARTZ_GEORE_DOWSING_ROD, (ItemLike)Items.QUARTZ, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.REDSTONE_GEORE_DOWSING_ROD, (ItemLike)Items.REDSTONE, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.ANCIENT_DEBRIS_GEORE_DOWSING_ROD, (ItemLike)Items.ANCIENT_DEBRIS, output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.RUBY_GEORE_DOWSING_ROD, this.createTag("gems/ruby"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.SAPPHIRE_GEORE_DOWSING_ROD, this.createTag("gems/sapphire"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.TOPAZ_GEORE_DOWSING_ROD, this.createTag("gems/topaz"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.ZINC_GEORE_DOWSING_ROD, this.createTag("ingots/zinc"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.URANINITE_GEORE_DOWSING_ROD, this.createTag("raw_materials/uraninite"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.BLACK_QUARTZ_GEORE_DOWSING_ROD, this.createTag("gems/black_quartz"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.MONAZITE_GEORE_DOWSING_ROD, this.createTag("dusts/monazite"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.ALUMINUM_GEORE_DOWSING_ROD, this.createTag("ingots/aluminum"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.LEAD_GEORE_DOWSING_ROD, this.createTag("ingots/lead"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.NICKEL_GEORE_DOWSING_ROD, this.createTag("ingots/nickel"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.OSMIUM_GEORE_DOWSING_ROD, this.createTag("ingots/osmium"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.PLATINUM_GEORE_DOWSING_ROD, this.createTag("ingots/platinum"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.SILVER_GEORE_DOWSING_ROD, this.createTag("ingots/silver"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.TIN_GEORE_DOWSING_ROD, this.createTag("ingots/tin"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.TUNGSTEN_GEORE_DOWSING_ROD, this.createTag("ingots/tungsten"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.URANIUM_GEORE_DOWSING_ROD, this.createTag("ingots/uranium"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.ALLTHEMODIUM_GEORE_DOWSING_ROD, this.createTag("ingots/allthemodium"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.VIBRANIUM_GEORE_DOWSING_ROD, this.createTag("ingots/vibranium"), output);
            this.generateRodRecipe((DeferredHolder<Item, ? extends Item>)CompatRegistry.UNOBTAINIUM_GEORE_DOWSING_ROD, this.createTag("ingots/unobtainium"), output);
        }

        private TagKey<Item> createTag(String tagName) {
            return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tagName));
        }

        private void generateRodRecipe(DeferredHolder<Item, ? extends Item> rod, ItemLike itemLike, RecipeOutput output) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)rod.get())).pattern(" O ").pattern("ORO").pattern(" O ").define(Character.valueOf('R'), (ItemLike)ItemsRegistry.DOWSING_ROD).define(Character.valueOf('O'), itemLike).unlockedBy("has_dowsing_rod", Recipes.has((ItemLike)ItemsRegistry.DOWSING_ROD)).unlockedBy("has_ore", Recipes.has((ItemLike)itemLike)).save(output);
        }

        private void generateRodRecipe(DeferredHolder<Item, ? extends Item> rod, TagKey<Item> itemTag, RecipeOutput output) {
            RecipeOutput tagOutput = output.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(itemTag.location()))});
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)rod.get())).pattern(" O ").pattern("ORO").pattern(" O ").define(Character.valueOf('R'), (ItemLike)ItemsRegistry.DOWSING_ROD).define(Character.valueOf('O'), itemTag).unlockedBy("has_dowsing_rod", Recipes.has((ItemLike)ItemsRegistry.DOWSING_ROD)).unlockedBy("has_ore", Recipes.has(itemTag)).save(tagOutput);
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "georenouveau", "en_us");
        }

        protected void addTranslations() {
            this.addEntityType(CompatRegistry.GEORE_GOLEM, "GeOre Golem");
            this.generateCharmLang(CompatRegistry.COAL_GEORE_GOLEM_CHARM, "Coal");
            this.generateCharmLang(CompatRegistry.COPPER_GEORE_GOLEM_CHARM, "Copper");
            this.generateCharmLang(CompatRegistry.DIAMOND_GEORE_GOLEM_CHARM, "Diamond");
            this.generateCharmLang(CompatRegistry.EMERALD_GEORE_GOLEM_CHARM, "Emerald");
            this.generateCharmLang(CompatRegistry.GOLD_GEORE_GOLEM_CHARM, "Gold");
            this.generateCharmLang(CompatRegistry.IRON_GEORE_GOLEM_CHARM, "Iron");
            this.generateCharmLang(CompatRegistry.LAPIS_GEORE_GOLEM_CHARM, "Lapis");
            this.generateCharmLang(CompatRegistry.QUARTZ_GEORE_GOLEM_CHARM, "Quartz");
            this.generateCharmLang(CompatRegistry.REDSTONE_GEORE_GOLEM_CHARM, "Redstone");
            this.generateCharmLang(CompatRegistry.ANCIENT_DEBRIS_GEORE_GOLEM_CHARM, "Ancient Debris");
            this.generateCharmLang(CompatRegistry.RUBY_GEORE_GOLEM_CHARM, "Ruby");
            this.generateCharmLang(CompatRegistry.SAPPHIRE_GEORE_GOLEM_CHARM, "Sapphire");
            this.generateCharmLang(CompatRegistry.TOPAZ_GEORE_GOLEM_CHARM, "Topaz");
            this.generateCharmLang(CompatRegistry.ZINC_GEORE_GOLEM_CHARM, "Zinc");
            this.generateCharmLang(CompatRegistry.URANINITE_GEORE_GOLEM_CHARM, "Uraninite");
            this.generateCharmLang(CompatRegistry.BLACK_QUARTZ_GEORE_GOLEM_CHARM, "Black Quartz");
            this.generateCharmLang(CompatRegistry.MONAZITE_GEORE_GOLEM_CHARM, "Monazite");
            this.generateCharmLang(CompatRegistry.ALUMINUM_GEORE_GOLEM_CHARM, "Aluminum");
            this.generateCharmLang(CompatRegistry.LEAD_GEORE_GOLEM_CHARM, "Lead");
            this.generateCharmLang(CompatRegistry.NICKEL_GEORE_GOLEM_CHARM, "Nickel");
            this.generateCharmLang(CompatRegistry.OSMIUM_GEORE_GOLEM_CHARM, "Osmium");
            this.generateCharmLang(CompatRegistry.PLATINUM_GEORE_GOLEM_CHARM, "Platinum");
            this.generateCharmLang(CompatRegistry.SILVER_GEORE_GOLEM_CHARM, "Silver");
            this.generateCharmLang(CompatRegistry.TIN_GEORE_GOLEM_CHARM, "Tin");
            this.generateCharmLang(CompatRegistry.TUNGSTEN_GEORE_GOLEM_CHARM, "Tungsten");
            this.generateCharmLang(CompatRegistry.URANIUM_GEORE_GOLEM_CHARM, "Uranium");
            this.generateCharmLang(CompatRegistry.ALLTHEMODIUM_GEORE_GOLEM_CHARM, "Allthemodium");
            this.generateCharmLang(CompatRegistry.VIBRANIUM_GEORE_GOLEM_CHARM, "Vibranium");
            this.generateCharmLang(CompatRegistry.UNOBTAINIUM_GEORE_GOLEM_CHARM, "Unobtainium");
            this.generateDowsingLang(CompatRegistry.COAL_GEORE_DOWSING_ROD, "Coal");
            this.generateDowsingLang(CompatRegistry.COPPER_GEORE_DOWSING_ROD, "Copper");
            this.generateDowsingLang(CompatRegistry.DIAMOND_GEORE_DOWSING_ROD, "Diamond");
            this.generateDowsingLang(CompatRegistry.EMERALD_GEORE_DOWSING_ROD, "Emerald");
            this.generateDowsingLang(CompatRegistry.GOLD_GEORE_DOWSING_ROD, "Gold");
            this.generateDowsingLang(CompatRegistry.IRON_GEORE_DOWSING_ROD, "Iron");
            this.generateDowsingLang(CompatRegistry.LAPIS_GEORE_DOWSING_ROD, "Lapis");
            this.generateDowsingLang(CompatRegistry.QUARTZ_GEORE_DOWSING_ROD, "Quartz");
            this.generateDowsingLang(CompatRegistry.REDSTONE_GEORE_DOWSING_ROD, "Redstone");
            this.generateDowsingLang(CompatRegistry.ANCIENT_DEBRIS_GEORE_DOWSING_ROD, "Ancient Debris");
            this.generateDowsingLang(CompatRegistry.RUBY_GEORE_DOWSING_ROD, "Ruby");
            this.generateDowsingLang(CompatRegistry.SAPPHIRE_GEORE_DOWSING_ROD, "Sapphire");
            this.generateDowsingLang(CompatRegistry.TOPAZ_GEORE_DOWSING_ROD, "Topaz");
            this.generateDowsingLang(CompatRegistry.ZINC_GEORE_DOWSING_ROD, "Zinc");
            this.generateDowsingLang(CompatRegistry.URANINITE_GEORE_DOWSING_ROD, "Uraninite");
            this.generateDowsingLang(CompatRegistry.BLACK_QUARTZ_GEORE_DOWSING_ROD, "Black Quartz");
            this.generateDowsingLang(CompatRegistry.MONAZITE_GEORE_DOWSING_ROD, "Monazite");
            this.generateDowsingLang(CompatRegistry.ALUMINUM_GEORE_DOWSING_ROD, "Aluminum");
            this.generateDowsingLang(CompatRegistry.LEAD_GEORE_DOWSING_ROD, "Lead");
            this.generateDowsingLang(CompatRegistry.NICKEL_GEORE_DOWSING_ROD, "Nickel");
            this.generateDowsingLang(CompatRegistry.OSMIUM_GEORE_DOWSING_ROD, "Osmium");
            this.generateDowsingLang(CompatRegistry.PLATINUM_GEORE_DOWSING_ROD, "Platinum");
            this.generateDowsingLang(CompatRegistry.SILVER_GEORE_DOWSING_ROD, "Silver");
            this.generateDowsingLang(CompatRegistry.TIN_GEORE_DOWSING_ROD, "Tin");
            this.generateDowsingLang(CompatRegistry.TUNGSTEN_GEORE_DOWSING_ROD, "Tungsten");
            this.generateDowsingLang(CompatRegistry.URANIUM_GEORE_DOWSING_ROD, "Uranium");
            this.generateDowsingLang(CompatRegistry.ALLTHEMODIUM_GEORE_DOWSING_ROD, "Allthemodium");
            this.generateDowsingLang(CompatRegistry.VIBRANIUM_GEORE_DOWSING_ROD, "Vibranium");
            this.generateDowsingLang(CompatRegistry.UNOBTAINIUM_GEORE_DOWSING_ROD, "Unobtainium");
            this.add("georenouveau.gui.jei.category.conversion", "GeOre Golem Conversion");
            this.add("georenouveau.gui.jei.category.conversion.required", "Only a %s GeOre Golem can perform this conversion.");
        }

        protected void generateCharmLang(DeferredItem<GeOreGolemCharm> registryObject, String name) {
            this.addItem((Supplier)registryObject, name + " GeOre Golem Charm");
            this.add("tooltip.geore_nouveau." + name.replaceAll(" ", "_").toLowerCase(Locale.ROOT) + "_charm", "Obtained by performing the Ritual of Awakening near Budding " + name + " GeOre");
        }

        protected void generateDowsingLang(DeferredItem<GeOreDowsingRod> registryObject, String name) {
            this.addItem((Supplier)registryObject, name + " GeOre Dowsing Rod");
            this.add("tooltip.geore_nouveau." + name.replaceAll(" ", "_").toLowerCase(Locale.ROOT) + "_dowsing_rod", "Grants Magic Find and Scrying on use, causing magical creatures to glow and " + name + " GeOre to be revealed through blocks. Can be used on Imbuement Chamber and Enchanting Apparatus to highlight linked pedestals.");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "georenouveau", helper);
        }

        protected void registerModels() {
            this.generateCharm(CompatRegistry.COAL_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.COPPER_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.DIAMOND_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.EMERALD_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.GOLD_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.IRON_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.LAPIS_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.QUARTZ_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.REDSTONE_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.ANCIENT_DEBRIS_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.RUBY_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.SAPPHIRE_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.TOPAZ_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.ZINC_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.URANINITE_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.BLACK_QUARTZ_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.MONAZITE_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.ALUMINUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.LEAD_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.NICKEL_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.OSMIUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.PLATINUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.SILVER_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.TIN_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.TUNGSTEN_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.URANIUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.ALLTHEMODIUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.VIBRANIUM_GEORE_GOLEM_CHARM);
            this.generateCharm(CompatRegistry.UNOBTAINIUM_GEORE_GOLEM_CHARM);
            this.generateRod(CompatRegistry.COAL_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.COPPER_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.DIAMOND_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.EMERALD_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.GOLD_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.IRON_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.LAPIS_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.QUARTZ_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.REDSTONE_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.ANCIENT_DEBRIS_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.RUBY_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.SAPPHIRE_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.TOPAZ_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.ZINC_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.URANINITE_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.BLACK_QUARTZ_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.MONAZITE_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.ALUMINUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.LEAD_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.NICKEL_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.OSMIUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.PLATINUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.SILVER_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.TIN_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.TUNGSTEN_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.URANIUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.ALLTHEMODIUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.VIBRANIUM_GEORE_DOWSING_ROD);
            this.generateRod(CompatRegistry.UNOBTAINIUM_GEORE_DOWSING_ROD);
        }

        protected void generateCharm(DeferredItem<GeOreGolemCharm> deferredItem) {
            String path = deferredItem.getId().getPath();
            this.singleTexture(path, ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", this.modLoc("item/" + path.replace("_geore_golem_", "_golem_")));
        }

        protected void generateRod(DeferredItem<GeOreDowsingRod> deferredItem) {
            this.withExistingParent(deferredItem.getId().getPath(), this.modLoc("item/dowsing_rod"));
        }
    }
}

