/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.entity.goal;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.shynieke.georenouveau.entity.GeOreGolem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GeOreHarvestClusterGoal
extends Goal {
    public GeOreGolem golem;
    public Supplier<Boolean> canUse;
    int tickTime;
    boolean isDone;
    List<BlockPos> harvestableList = new ArrayList<BlockPos>();

    public GeOreHarvestClusterGoal(GeOreGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public void tick() {
        super.tick();
        --this.tickTime;
        this.golem.getNavigation().stop();
        if (this.tickTime % 40 == 0) {
            this.tryDropAmethyst();
        }
        if (this.tickTime <= 0 || this.harvestableList.isEmpty()) {
            this.isDone = true;
            this.golem.setStomping(false);
            this.golem.harvestCooldown = 1200;
        }
    }

    public void tryDropAmethyst() {
        ArrayList<BlockPos> harvested = new ArrayList<BlockPos>();
        for (BlockPos p : this.harvestableList) {
            if (!this.hasCluster(p)) continue;
            harvested.add(p);
            this.harvest(p);
            break;
        }
        for (BlockPos p : harvested) {
            this.harvestableList.remove(p);
        }
    }

    public void harvest(BlockPos p) {
        Direction[] directionArray = this.golem.level();
        if (!(directionArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)directionArray;
        for (Direction d : Direction.values()) {
            BlockState state = level.getBlockState(p.relative(d));
            if (!state.is(this.golem.getLinkedGeOre().getCluster())) continue;
            ItemStack stack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
            state.getBlock().playerDestroy((Level)level, (Player)ANFakePlayer.getPlayer((ServerLevel)level), p.relative(d), state, level.getBlockEntity(p), stack);
            BlockUtil.destroyBlockSafely((Level)level, (BlockPos)p.relative(d), (boolean)false, (LivingEntity)ANFakePlayer.getPlayer((ServerLevel)level));
        }
    }

    public boolean hasCluster(BlockPos p) {
        for (Direction d : Direction.values()) {
            if (!this.golem.level().getBlockState(p.relative(d)).is(this.golem.getLinkedGeOre().getCluster())) continue;
            return true;
        }
        return false;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        super.start();
        this.golem.setStomping(true);
        this.golem.getNavigation().stop();
        this.isDone = false;
        this.harvestableList = new ArrayList<BlockPos>(this.golem.buddingBlocks);
        Collections.shuffle(this.harvestableList);
        this.tickTime = 130;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.HARVEST;
    }

    public void stop() {
        this.golem.setStomping(false);
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean canContinueToUse() {
        return !this.isDone;
    }

    public boolean canUse() {
        return this.canUse.get() != false && !this.golem.buddingBlocks.isEmpty();
    }
}

