/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.shynieke.georenouveau.entity.GeOreGolem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;

public class GeOrePickupAmethystGoal
extends Goal {
    public GeOreGolem golem;
    public Supplier<Boolean> canUse;
    ItemEntity targetEntity;
    int usingTicks;
    boolean isDone;

    public GeOrePickupAmethystGoal(GeOreGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public boolean canContinueToUse() {
        return this.targetEntity != null && !this.isDone;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        if (this.usingTicks <= 0) {
            this.isDone = true;
            this.collectStacks();
            return;
        }
        if (this.targetEntity == null || this.targetEntity.isRemoved() || !this.targetEntity.getItem().is(this.golem.getLinkedGeOre().getShard())) {
            this.isDone = true;
            return;
        }
        this.golem.getNavigation().tryMoveToBlockPos(this.targetEntity.blockPosition(), 1.0);
        if (BlockUtil.distanceFrom((BlockPos)this.golem.blockPosition(), (BlockPos)this.targetEntity.blockPosition()) <= 1.5) {
            this.collectStacks();
            this.isDone = true;
            this.golem.pickupCooldown = 60 + this.golem.getRandom().nextInt(10);
        }
    }

    public void collectStacks() {
        for (ItemEntity i : this.golem.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.golem.getHome()).inflate(10.0))) {
            if (!i.getItem().is(this.golem.getLinkedGeOre().getShard())) continue;
            int maxTake = this.golem.getMainHandItem().getMaxStackSize() - this.golem.getMainHandItem().getCount();
            if (this.golem.getMainHandItem().isEmpty()) {
                this.golem.setHeldStack(i.getItem().copy());
                i.getItem().setCount(0);
                continue;
            }
            int toTake = Math.min(i.getItem().getCount(), maxTake);
            i.getItem().shrink(toTake);
            this.golem.getMainHandItem().grow(toTake);
        }
    }

    public void stop() {
        this.isDone = false;
        this.usingTicks = 80;
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
        this.golem.pickupCooldown = 60 + this.golem.getRandom().nextInt(10);
    }

    public void start() {
        this.isDone = false;
        this.usingTicks = 80;
        for (ItemEntity entity : this.golem.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.golem.getHome()).inflate(10.0))) {
            if (!entity.getItem().is(this.golem.getLinkedGeOre().getShard())) continue;
            this.golem.getNavigation().tryMoveToBlockPos(entity.blockPosition(), 1.0);
            this.targetEntity = entity;
            break;
        }
        if (this.targetEntity == null) {
            this.isDone = true;
        }
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.PICKUP;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canUse() {
        if (this.golem.getHome() == null) {
            return false;
        }
        BlockEntity entity = this.golem.level().getBlockEntity(this.golem.getHome());
        return this.canUse.get() != false && this.golem.pickupCooldown <= 0 && entity != null && entity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, entity.getBlockPos(), null) != null;
    }
}

