/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ItemCollector {
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    public void add(ItemStack stack) {
        if (!stack.isEmpty()) {
            this.items.add(stack.copy());
        }
    }

    public void drop(Level level, BlockPos pos) {
        if (this.items.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (!stack.isStackable()) {
                stacks.add(stack);
                continue;
            }
            for (int i = 0; i < stacks.size() && !(stack = this.insert(stacks, stack, i)).isEmpty(); ++i) {
            }
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        for (ItemStack stack : stacks) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    private ItemStack insert(List<ItemStack> stacks, ItemStack stack, int slot) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = stacks.get(slot);
        if (existing.isEmpty()) {
            stacks.set(slot, stack.copy());
            return ItemStack.EMPTY;
        }
        if (!stack.isStackable() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
            return stack;
        }
        int available = stack.getMaxStackSize() - existing.getCount();
        int toAdd = Math.min(available, stack.getCount());
        existing.grow(toAdd);
        return toAdd == stack.getCount() ? ItemStack.EMPTY : stack.copyWithCount(stack.getCount() - toAdd);
    }
}

