/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.api.FTBUltimineAPI;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record SyncUltimineTimePacket(long when, TimeType timetype) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncUltimineTimePacket> TYPE = new CustomPacketPayload.Type(FTBUltimineAPI.id("sync_ultimine_time_packet"));
    public static final StreamCodec<FriendlyByteBuf, SyncUltimineTimePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SyncUltimineTimePacket::when, (StreamCodec)NetworkHelper.enumStreamCodec(TimeType.class), SyncUltimineTimePacket::timetype, SyncUltimineTimePacket::new);

    public CustomPacketPayload.Type<SyncUltimineTimePacket> type() {
        return TYPE;
    }

    public static void handle(SyncUltimineTimePacket message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            switch (message.timetype.ordinal()) {
                case 1: {
                    CooldownTracker.setLastUltimineTime(FTBUltimineClient.getClientPlayer(), message.when);
                    break;
                }
                case 0: {
                    CooldownTracker.setClientCooldownTime(message.when);
                }
            }
        });
    }

    public static enum TimeType {
        COOLDOWN,
        LAST_USED;

    }
}

