/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PacketGeneratorsTileButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos pos) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGeneratorsTileButtonPress> TYPE = new CustomPacketPayload.Type(MekanismGenerators.rl("tile_button"));
    public static final StreamCodec<ByteBuf, PacketGeneratorsTileButtonPress> STREAM_CODEC = StreamCodec.composite(ClickedGeneratorsTileButton.STREAM_CODEC, PacketGeneratorsTileButtonPress::buttonClicked, (StreamCodec)BlockPos.STREAM_CODEC, PacketGeneratorsTileButtonPress::pos, PacketGeneratorsTileButtonPress::new);

    @NotNull
    public CustomPacketPayload.Type<PacketGeneratorsTileButtonPress> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.pos);
        MenuProvider provider = this.buttonClicked.getProvider(tile);
        if (provider != null) {
            player.openMenu(provider, buf -> {
                buf.writeBlockPos(this.pos);
                this.buttonClicked.encodeExtraData((RegistryFriendlyByteBuf)buf, tile);
            });
        }
    }

    public static enum ClickedGeneratorsTileButton {
        TAB_MAIN(tile -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.INDUSTRIAL_TURBINE.getProvider((ILangEntry)GeneratorsLang.TURBINE, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR.getProvider((ILangEntry)GeneratorsLang.FISSION_REACTOR, tile);
            }
            return null;
        }, (buffer, tile) -> tile.encodeExtraContainerData(buffer)),
        TAB_HEAT(tile -> GeneratorsContainerTypes.FUSION_REACTOR_HEAT.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile)),
        TAB_FUEL(tile -> GeneratorsContainerTypes.FUSION_REACTOR_FUEL.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile)),
        TAB_STATS(tile -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.TURBINE_STATS.getProvider((ILangEntry)GeneratorsLang.TURBINE_STATS, tile);
            }
            if (tile instanceof TileEntityFusionReactorController) {
                return GeneratorsContainerTypes.FUSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.FISSION_REACTOR_STATS, tile);
            }
            return null;
        });

        public static final IntFunction<ClickedGeneratorsTileButton> BY_ID;
        public static final StreamCodec<ByteBuf, ClickedGeneratorsTileButton> STREAM_CODEC;
        private final Function<TileEntityMekanism, @Nullable MenuProvider> providerFromTile;
        @Nullable
        private final BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData;

        private ClickedGeneratorsTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile) {
            this(providerFromTile, null);
        }

        private ClickedGeneratorsTileButton(Function<TileEntityMekanism, MenuProvider> providerFromTile, BiConsumer<RegistryFriendlyByteBuf, TileEntityMekanism> extraEncodingData) {
            this.providerFromTile = providerFromTile;
            this.extraEncodingData = extraEncodingData;
        }

        @Nullable
        @Contract(value="null -> null")
        public MenuProvider getProvider(@Nullable TileEntityMekanism tile) {
            return tile == null ? null : this.providerFromTile.apply(tile);
        }

        private void encodeExtraData(RegistryFriendlyByteBuf buffer, TileEntityMekanism tile) {
            if (this.extraEncodingData != null) {
                this.extraEncodingData.accept(buffer, tile);
            }
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ClickedGeneratorsTileButton.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

