/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.SequencedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.helpers.RenderHelper;
import team.lodestar.lodestone.systems.rendering.StateShards;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class RenderHandler {
    public static final SequencedMap<RenderType, ByteBufferBuilder> BUFFERS = new LinkedHashMap<RenderType, ByteBufferBuilder>();
    public static final SequencedMap<RenderType, ByteBufferBuilder> PARTICLE_BUFFERS = new LinkedHashMap<RenderType, ByteBufferBuilder>();
    public static final SequencedMap<RenderType, ByteBufferBuilder> LATE_BUFFERS = new LinkedHashMap<RenderType, ByteBufferBuilder>();
    public static final SequencedMap<RenderType, ByteBufferBuilder> LATE_PARTICLE_BUFFERS = new LinkedHashMap<RenderType, ByteBufferBuilder>();
    public static final HashMap<RenderType, ShaderUniformHandler> UNIFORM_HANDLERS = new HashMap();
    public static final Collection<RenderType> TRANSPARENT_RENDER_TYPES = new ArrayList<RenderType>();
    public static RenderTarget LODESTONE_DEPTH_CACHE;
    public static LodestoneRenderLayer DELAYED_RENDER;
    public static LodestoneRenderLayer LATE_DELAYED_RENDER;
    public static Matrix4f MAIN_PROJ;
    public static Matrix4f MATRIX4F;
    public static float FOG_NEAR;
    public static float FOG_FAR;
    public static FogShape FOG_SHAPE;
    public static float FOG_RED;
    public static float FOG_GREEN;
    public static float FOG_BLUE;

    public static void onClientSetup(FMLClientSetupEvent event) {
        DELAYED_RENDER = new LodestoneRenderLayer(BUFFERS, PARTICLE_BUFFERS);
        LATE_DELAYED_RENDER = new LodestoneRenderLayer(LATE_BUFFERS, LATE_PARTICLE_BUFFERS);
    }

    public static void resize(int width, int height) {
        if (LODESTONE_DEPTH_CACHE != null) {
            LODESTONE_DEPTH_CACHE.resize(width, height, Minecraft.ON_OSX);
        }
    }

    public static void endBatches() {
        RenderHandler.copyDepthBuffer(LODESTONE_DEPTH_CACHE);
        RenderHandler.endBatches(DELAYED_RENDER);
        RenderHandler.endBatches(LATE_DELAYED_RENDER);
    }

    public static void endBatches(LodestoneRenderLayer renderLayer) {
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedParticles(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, false);
        RenderHandler.renderBufferedParticles(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    public static void cacheFogData(ViewportEvent.RenderFog event) {
        FOG_NEAR = event.getNearPlaneDistance();
        FOG_FAR = event.getFarPlaneDistance();
        FOG_SHAPE = event.getFogShape();
    }

    public static void cacheFogData(ViewportEvent.ComputeFogColor event) {
        FOG_RED = event.getRed();
        FOG_GREEN = event.getGreen();
        FOG_BLUE = event.getBlue();
    }

    public static void beginBufferedRendering() {
        float[] shaderFogColor = RenderSystem.getShaderFogColor();
        float fogRed = shaderFogColor[0];
        float fogGreen = shaderFogColor[1];
        float fogBlue = shaderFogColor[2];
        float shaderFogStart = RenderSystem.getShaderFogStart();
        float shaderFogEnd = RenderSystem.getShaderFogEnd();
        FogShape shaderFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
        FOG_RED = fogRed;
        FOG_GREEN = fogGreen;
        FOG_BLUE = fogBlue;
        FOG_NEAR = shaderFogStart;
        FOG_FAR = shaderFogEnd;
        FOG_SHAPE = shaderFogShape;
    }

    public static void endBufferedRendering() {
        RenderSystem.setShaderFogStart((float)FOG_NEAR);
        RenderSystem.setShaderFogEnd((float)FOG_FAR);
        RenderSystem.setShaderFogShape((FogShape)FOG_SHAPE);
        RenderSystem.setShaderFogColor((float)FOG_RED, (float)FOG_GREEN, (float)FOG_BLUE);
    }

    public static void renderBufferedParticles(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.getParticleTarget(), renderLayer.getParticleBuffers(), transparentOnly);
    }

    public static void renderBufferedBatches(LodestoneRenderLayer renderLayer, boolean transparentOnly) {
        RenderHandler.renderBufferedBatches(renderLayer.getTarget(), renderLayer.getBuffers(), transparentOnly);
    }

    private static void renderBufferedBatches(MultiBufferSource.BufferSource bufferSource, SequencedMap<RenderType, ByteBufferBuilder> buffer, boolean transparentOnly) {
        if (transparentOnly) {
            RenderHandler.endBatches(bufferSource, TRANSPARENT_RENDER_TYPES);
        } else {
            ArrayList<RenderType> nonTransparentRenderTypes = new ArrayList<RenderType>(buffer.keySet());
            nonTransparentRenderTypes.removeIf(TRANSPARENT_RENDER_TYPES::contains);
            RenderHandler.endBatches(bufferSource, nonTransparentRenderTypes);
        }
    }

    public static void endBatches(MultiBufferSource.BufferSource source, Collection<RenderType> renderTypes) {
        for (RenderType type : renderTypes) {
            Optional<ShaderInstance> optional = RenderHelper.getShader(type);
            if (optional.isPresent()) {
                ShaderInstance instance = optional.get();
                if (UNIFORM_HANDLERS.containsKey(type)) {
                    ShaderUniformHandler handler = UNIFORM_HANDLERS.get(type);
                    handler.updateShaderData(instance);
                }
                instance.setSampler("SceneDepthBuffer", (Object)LODESTONE_DEPTH_CACHE.getDepthTextureId());
                instance.setSampler("SceneDiffuseBuffer", (Object)Minecraft.getInstance().getMainRenderTarget().getColorTextureId());
                instance.safeGetUniform("InvProjMat").set(new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert());
                source.endBatch(type);
                if (!(instance instanceof ExtendedShaderInstance)) continue;
                ExtendedShaderInstance extendedShaderInstance = (ExtendedShaderInstance)instance;
                extendedShaderInstance.setUniformDefaults();
                continue;
            }
            source.endBatch(type);
        }
    }

    public static void addRenderType(RenderType renderType) {
        boolean isParticle = renderType.name.contains("particle");
        SequencedMap<RenderType, ByteBufferBuilder> buffers = isParticle ? PARTICLE_BUFFERS : BUFFERS;
        SequencedMap<RenderType, ByteBufferBuilder> lateBuffers = isParticle ? LATE_PARTICLE_BUFFERS : LATE_BUFFERS;
        buffers.put(renderType, new ByteBufferBuilder(786432));
        lateBuffers.put(renderType, new ByteBufferBuilder(786432));
        if (StateShards.NORMAL_TRANSPARENCY.equals(RenderHelper.getTransparencyShard(renderType))) {
            TRANSPARENT_RENDER_TYPES.add(renderType);
        }
    }

    public static void copyDepthBuffer(RenderTarget tempRenderTarget) {
        RenderHandler.setupDepthBuffer();
        RenderHandler.enableStencil();
        if (tempRenderTarget == null) {
            return;
        }
        RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();
        tempRenderTarget.copyDepthFrom(mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.frameBufferId);
    }

    public static void setupDepthBuffer() {
        if (LODESTONE_DEPTH_CACHE == null) {
            LODESTONE_DEPTH_CACHE = new TextureTarget(Minecraft.getInstance().getMainRenderTarget().width, Minecraft.getInstance().getMainRenderTarget().height, true, Minecraft.ON_OSX);
        }
    }

    public static void enableStencil() {
        if (Minecraft.getInstance().getMainRenderTarget().isStencilEnabled()) {
            LODESTONE_DEPTH_CACHE.enableStencil();
        }
    }

    static {
        DELAYED_RENDER = new LodestoneRenderLayer(BUFFERS, PARTICLE_BUFFERS);
        LATE_DELAYED_RENDER = new LodestoneRenderLayer(LATE_BUFFERS, LATE_PARTICLE_BUFFERS);
    }

    public static class LodestoneRenderLayer {
        protected final SequencedMap<RenderType, ByteBufferBuilder> buffers;
        protected final SequencedMap<RenderType, ByteBufferBuilder> particleBuffers;
        protected final MultiBufferSource.BufferSource target;
        protected final MultiBufferSource.BufferSource particleTarget;

        public LodestoneRenderLayer(SequencedMap<RenderType, ByteBufferBuilder> buffers, SequencedMap<RenderType, ByteBufferBuilder> particleBuffers) {
            this.buffers = buffers;
            this.particleBuffers = particleBuffers;
            this.target = MultiBufferSource.immediateWithBuffers(buffers, (ByteBufferBuilder)new ByteBufferBuilder(786432));
            this.particleTarget = MultiBufferSource.immediateWithBuffers(particleBuffers, (ByteBufferBuilder)new ByteBufferBuilder(786432));
        }

        public SequencedMap<RenderType, ByteBufferBuilder> getBuffers() {
            return this.buffers;
        }

        public SequencedMap<RenderType, ByteBufferBuilder> getParticleBuffers() {
            return this.particleBuffers;
        }

        public MultiBufferSource.BufferSource getTarget() {
            return this.target;
        }

        public MultiBufferSource.BufferSource getParticleTarget() {
            return this.particleTarget;
        }
    }
}

