/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.helpers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityHelper {
    public static HitResult pick(LivingEntity entity) {
        double d0 = entity.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        double d1 = entity.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        return EntityHelper.pick((Entity)entity, d0, d1);
    }

    public static HitResult pick(Entity entity, double blockInteractionRange, double entityInteractionRange) {
        double d0 = Math.max(blockInteractionRange, entityInteractionRange);
        double d1 = Mth.square((double)d0);
        Vec3 vec3 = entity.getEyePosition();
        HitResult hitresult = entity.pick(d0, 0.0f, false);
        double d2 = hitresult.getLocation().distanceToSqr(vec3);
        if (hitresult.getType() != HitResult.Type.MISS) {
            d1 = d2;
            d0 = Math.sqrt(d2);
        }
        Vec3 vec31 = entity.getViewVector(0.0f);
        Vec3 vec32 = vec3.add(vec31.x * d0, vec31.y * d0, vec31.z * d0);
        float f = 1.0f;
        AABB aabb = entity.getBoundingBox().expandTowards(vec31.scale(d0)).inflate(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, p_234237_ -> !p_234237_.isSpectator() && p_234237_.isPickable(), (double)d1);
        return entityhitresult != null && entityhitresult.getLocation().distanceToSqr(vec3) < d2 ? EntityHelper.filterHitResult((HitResult)entityhitresult, vec3, entityInteractionRange) : EntityHelper.filterHitResult(hitresult, vec3, blockInteractionRange);
    }

    public static HitResult filterHitResult(HitResult hitResult, Vec3 pos, double blockInteractionRange) {
        Vec3 vec3 = hitResult.getLocation();
        if (!vec3.closerThan((Position)pos, blockInteractionRange)) {
            Vec3 vec31 = hitResult.getLocation();
            Direction direction = Direction.getNearest((double)(vec31.x - pos.x), (double)(vec31.y - pos.y), (double)(vec31.z - pos.z));
            return BlockHitResult.miss((Vec3)vec31, (Direction)direction, (BlockPos)BlockPos.containing((Position)vec31));
        }
        return hitResult;
    }

    public static void amplifyEffect(MobEffectInstance instance, LivingEntity target, int addedAmplifier, int cap) {
        instance.amplifier = Math.max(Math.min(cap, instance.getAmplifier() + addedAmplifier), instance.getAmplifier());
        EntityHelper.syncEffect(instance, target);
    }

    public static void amplifyEffect(MobEffectInstance instance, LivingEntity target, int addedAmplifier) {
        instance.amplifier = instance.getAmplifier() + addedAmplifier;
        EntityHelper.syncEffect(instance, target);
    }

    public static void extendEffect(MobEffectInstance instance, LivingEntity target, int addedDuration, int cap) {
        instance.duration = Math.max(Math.min(cap, instance.getDuration() + addedDuration), instance.getDuration());
        EntityHelper.syncEffect(instance, target);
    }

    public static void extendEffect(MobEffectInstance instance, LivingEntity target, int addedDuration) {
        instance.duration = instance.getDuration() + addedDuration;
        EntityHelper.syncEffect(instance, target);
    }

    public static void shortenEffect(MobEffectInstance instance, LivingEntity target, int removedDuration) {
        instance.duration = instance.getDuration() - removedDuration;
        EntityHelper.syncEffect(instance, target);
    }

    public static void syncEffect(MobEffectInstance instance, LivingEntity target) {
        target.effectsDirty = true;
        target.onEffectUpdated(instance, true, (Entity)target);
    }
}

