/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.postprocess;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.EffectInstance;
import org.joml.Matrix4f;
import team.lodestar.lodestone.LodestoneLib;
import team.lodestar.lodestone.systems.postprocess.DynamicShaderFxInstance;
import team.lodestar.lodestone.systems.postprocess.PostProcessor;
import team.lodestar.lodestone.systems.postprocess.ShaderDataBuffer;

public abstract class MultiInstancePostProcessor<I extends DynamicShaderFxInstance>
extends PostProcessor {
    private final List<DynamicShaderFxInstance> instances = new ArrayList<DynamicShaderFxInstance>(this.getMaxInstances());
    private final ShaderDataBuffer dataBuffer = new ShaderDataBuffer();

    protected abstract int getMaxInstances();

    protected abstract int getDataSizePerInstance();

    @Override
    public void init() {
        super.init();
        this.dataBuffer.generate((long)this.getMaxInstances() * (long)this.getDataSizePerInstance());
    }

    @Nullable
    public I addFxInstance(I instance) {
        if (this.instances.size() >= this.getMaxInstances()) {
            LodestoneLib.LOGGER.warn("Failed to add fx instance to " + String.valueOf(this) + ": reached max instance count of " + this.getMaxInstances());
            return null;
        }
        this.instances.add((DynamicShaderFxInstance)instance);
        this.setActive(true);
        return instance;
    }

    @Override
    public void beforeProcess(Matrix4f viewModelMatrix) {
        for (int i = this.instances.size() - 1; i >= 0; --i) {
            DynamicShaderFxInstance instance = this.instances.get(i);
            instance.update(MC.getTimer().getGameTimeDeltaPartialTick(false));
            if (!instance.isRemoved()) continue;
            this.instances.remove(i);
        }
        if (this.instances.isEmpty()) {
            this.setActive(false);
            return;
        }
        float[] data = new float[this.instances.size() * this.getDataSizePerInstance()];
        for (int ins = 0; ins < this.instances.size(); ++ins) {
            DynamicShaderFxInstance instance = this.instances.get(ins);
            int offset = ins * this.getDataSizePerInstance();
            instance.writeDataToBuffer((index, d) -> {
                if (index >= this.getDataSizePerInstance() || index < 0) {
                    throw new IndexOutOfBoundsException((int)index);
                }
                data[offset + index.intValue()] = d.floatValue();
            });
        }
        this.dataBuffer.upload(data);
    }

    protected void setDataBufferUniform(EffectInstance effectInstance, String bufferName, String countName) {
        this.dataBuffer.apply(effectInstance, bufferName);
        effectInstance.safeGetUniform(countName).set(this.instances.size());
    }

    public ImmutableList<DynamicShaderFxInstance> getInstances() {
        return ImmutableList.copyOf(this.instances);
    }
}

