/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.texture;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.common.NeoForgeConfig;
import team.lodestar.lodestone.systems.texture.InternalTextureFormat;

public class CustomizableTextureTarget
extends RenderTarget {
    private final InternalTextureFormat internalFormat;

    public CustomizableTextureTarget(int width, int height, boolean useDepth) {
        this(width, height, useDepth, InternalTextureFormat.RGBA16F);
    }

    public CustomizableTextureTarget(int width, int height, boolean useDepth, InternalTextureFormat internalFormat) {
        super(useDepth);
        this.internalFormat = internalFormat;
        RenderSystem.assertOnRenderThreadOrInit();
        this.resize(width, height, Minecraft.ON_OSX);
    }

    public void createBuffers(int width, int height, boolean clearError) {
        RenderSystem.assertOnRenderThreadOrInit();
        int i = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= i && height > 0 && height <= i) {
            this.viewWidth = width;
            this.viewHeight = height;
            this.width = width;
            this.height = height;
            this.frameBufferId = GlStateManager.glGenFramebuffers();
            this.colorTextureId = TextureUtil.generateTextureId();
            if (this.useDepth) {
                this.depthBufferId = TextureUtil.generateTextureId();
                GlStateManager._bindTexture((int)this.depthBufferId);
                GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
                GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
                GlStateManager._texParameter((int)3553, (int)34892, (int)0);
                GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
                GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
                if (!this.isStencilEnabled()) {
                    GlStateManager._texImage2D((int)3553, (int)0, (int)6402, (int)this.width, (int)this.height, (int)0, (int)6402, (int)5126, null);
                } else {
                    GlStateManager._texImage2D((int)3553, (int)0, (int)36013, (int)this.width, (int)this.height, (int)0, (int)34041, (int)36269, null);
                }
            }
            this.setFilterMode(9728, true);
            GlStateManager._bindTexture((int)this.colorTextureId);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.internalFormat.getGlFormat(), (int)this.width, (int)this.height, (int)0, (int)6408, (int)this.internalFormat.getGlType(), null);
            GlStateManager._glBindFramebuffer((int)36160, (int)this.frameBufferId);
            GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colorTextureId, (int)0);
            if (this.useDepth) {
                if (!this.isStencilEnabled()) {
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthBufferId, (int)0);
                } else if (((Boolean)NeoForgeConfig.CLIENT.useCombinedDepthStencilAttachment.get()).booleanValue()) {
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.depthBufferId, (int)0);
                } else {
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.depthBufferId, (int)0);
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)36128, (int)3553, (int)this.depthBufferId, (int)0);
                }
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + i + ")");
        }
        this.checkStatus();
        this.clear(clearError);
        this.unbindRead();
    }
}

