/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.worldevent;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import team.lodestar.lodestone.registry.client.LodestoneWorldEventRenderers;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventRenderer;

public class WorldEventType {
    public final ResourceLocation id;
    public final EventInstanceSupplier<?> supplier;
    public final boolean clientSynced;

    public WorldEventType(ResourceLocation id, EventInstanceSupplier<?> supplier, boolean clientSynced) {
        this.id = id;
        this.supplier = supplier;
        this.clientSynced = clientSynced;
    }

    public WorldEventType(ResourceLocation id, EventInstanceSupplier<?> supplier) {
        this(id, supplier, false);
    }

    public boolean isClientSynced() {
        return this.clientSynced;
    }

    public WorldEventInstance createInstance(CompoundTag tag) {
        return ((WorldEventInstance)this.supplier.getInstance()).deserializeNBT(tag);
    }

    public static interface EventInstanceSupplier<T extends WorldEventInstance> {
        public T getInstance();
    }

    public static class Builder<T extends WorldEventInstance> {
        private final ResourceLocation id;
        private final EventInstanceSupplier<T> supplier;
        private boolean clientSynced;
        private WorldEventRenderer<T> renderer;

        private Builder(EventInstanceSupplier<T> supplier, ResourceLocation id) {
            this.id = id;
            this.supplier = supplier;
        }

        public static <T extends WorldEventInstance> Builder<T> of(EventInstanceSupplier<T> supplier, ResourceLocation id) {
            return new Builder<T>(supplier, id);
        }

        public Builder<T> clientSynced(@Nullable WorldEventRenderer<T> renderer) {
            this.clientSynced = true;
            this.renderer = renderer;
            return this;
        }

        public Builder<T> clientSynced() {
            return this.clientSynced(null);
        }

        public WorldEventType build() {
            WorldEventType type = new WorldEventType(this.id, this.supplier, this.clientSynced);
            if (FMLEnvironment.dist.equals((Object)Dist.CLIENT)) {
                LodestoneWorldEventRenderers.registerRenderer(type, this.renderer);
            }
            return type;
        }
    }
}

