/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.XNet;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.setup.Config;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class EnergyConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");
    private InsExtMode energyMode = InsExtMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    public static final MapCodec<EnergyConnectorSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractConnectorSettings.BaseSettings.CODEC.fieldOf("base").forGetter(settings -> settings.settings), (App)Direction.CODEC.fieldOf("side").forGetter(AbstractConnectorSettings::getSide), (App)InsExtMode.CODEC.fieldOf("mode").forGetter(EnergyConnectorSettings::getEnergyMode), (App)Codec.INT.optionalFieldOf("priority").forGetter(settings -> Optional.ofNullable(settings.priority)), (App)Codec.INT.optionalFieldOf("rate").forGetter(settings -> Optional.ofNullable(settings.rate)), (App)Codec.INT.optionalFieldOf("minmax").forGetter(settings -> Optional.ofNullable(settings.minmax))).apply((Applicative)instance, EnergyConnectorSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergyConnectorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)AbstractConnectorSettings.BaseSettings.STREAM_CODEC, s -> s.settings, (StreamCodec)Direction.STREAM_CODEC, AbstractConnectorSettings::getSide, InsExtMode.STREAM_CODEC, EnergyConnectorSettings::getEnergyMode, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.priority), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.rate), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT), s -> Optional.ofNullable(s.minmax), EnergyConnectorSettings::new);
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});

    public EnergyConnectorSettings(@Nonnull Direction side) {
        super(DEFAULT_SETTINGS, side);
    }

    public EnergyConnectorSettings(@Nonnull AbstractConnectorSettings.BaseSettings base, @Nonnull Direction side, InsExtMode energyMode, Optional<Integer> priority, Optional<Integer> rate, Optional<Integer> minmax) {
        super(base, side);
        this.energyMode = energyMode;
        this.priority = priority.orElse(null);
        this.rate = rate.orElse(null);
        this.minmax = minmax.orElse(null);
    }

    public IChannelType getType() {
        return XNet.setup.energyChannelType;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.energyMode) {
            default -> throw new MatchException(null, null);
            case InsExtMode.INS -> new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            case InsExtMode.EXT -> new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public InsExtMode getEnergyMode() {
        return this.energyMode;
    }

    private String getRateTooltip() {
        return I18nConstants.ENERGY_RATE_TOOLTIP_FORMATTED.i18n((this.energyMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), Config.getMaxRfRate(this.advanced));
    }

    private String getMinMaxTooltip() {
        return I18nConstants.ENERGY_MINMAX_TOOLTIP_FORMATTED.i18n((this.energyMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), (this.energyMode == InsExtMode.EXT ? I18nConstants.LOW_FORMAT : I18nConstants.HIGH_FORMAT).i18n(new Object[0]));
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.energyMode, (ITranslatableEnum[])InsExtMode.values());
        gui.nl().label(I18nConstants.PRIORITY_LABEL.i18n(new Object[0])).integer("priority", I18nConstants.PRIORITY_TOOLTIP.i18n(new Object[0]), this.priority, 30).nl().label(I18nConstants.RATE_LABEL.i18n(new Object[0])).integer("rate", this.getRateTooltip(), this.rate, 40).shift(10).label((this.energyMode == InsExtMode.EXT ? I18nConstants.MIN : I18nConstants.MAX).i18n(new Object[0])).integer("minmax", this.getMinMaxTooltip(), this.minmax, 50);
    }

    public boolean isEnabled(String tag) {
        if (this.energyMode == InsExtMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return false;
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getRate() {
        return this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.energyMode = CastTools.safeInsExtMode(data.get("mode"));
        this.rate = (Integer)data.get("rate");
        this.minmax = (Integer)data.get("minmax");
        this.priority = (Integer)data.get("priority");
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        EnergyConnectorSettings.setEnumSafe((JsonObject)object, (String)"energymode", (Enum)this.energyMode);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)"rate", (Integer)this.rate);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)"minmax", (Integer)this.minmax);
        if (this.rate != null && this.rate > (Integer)Config.maxRfRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.energyMode = (InsExtMode)EnergyConnectorSettings.getEnumSafe((JsonObject)object, (String)"energymode", EnumStringTranslators::getEnergyMode);
        this.priority = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.rate = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)"rate");
        this.minmax = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)"minmax");
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
    }
}

