/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic.enums;

import com.mojang.serialization.Codec;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ComponentFactory;
import mcjty.xnet.utils.I18nUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum SensorMode implements ITranslatableEnum<SensorMode>,
StringRepresentable
{
    OFF("xnet.enum.logic.sensormode.off"),
    ITEM("xnet.enum.logic.sensormode.item"),
    FLUID("xnet.enum.logic.sensormode.fluid"),
    ENERGY("xnet.enum.logic.sensormode.energy"),
    RS("xnet.enum.logic.sensormode.rs");

    private final String i18n;
    public static final Codec<SensorMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, SensorMode> STREAM_CODEC;

    private SensorMode(String i18n) {
        this.i18n = i18n;
    }

    public String getI18n() {
        return ComponentFactory.translatable((String)this.i18n).getString();
    }

    public String[] getI18nSplitedTooltip() {
        return I18nUtils.getSplitedEnumTooltip(this.i18n);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(SensorMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(SensorMode.class);
    }
}

