/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.blocks.FacadeTileEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.InterModComms;

public class TopExtras {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", GetTheOneProbe::new);
    }

    private static void registerTopExtras(ITheOneProbe probe) {
        probe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            Block block = blockState.getBlock();
            if (block == FacadeModule.FACADE.get()) {
                String modid = "XNet";
                ItemStack pickBlock = data.getPickBlock();
                BlockEntity te = world.getBlockEntity(data.getPos());
                if (te instanceof FacadeTileEntity) {
                    pickBlock = new ItemStack((ItemLike)CableModule.NETCABLE.get(), 1);
                }
                if (!pickBlock.isEmpty()) {
                    probeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modid));
                } else {
                    probeInfo.vertical().text(CompoundText.create().name(block.getDescriptionId())).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modid));
                }
                return true;
            }
            return false;
        });
    }

    private static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        private GetTheOneProbe() {
        }

        @Override
        public Void apply(ITheOneProbe probe) {
            TopExtras.registerTopExtras(probe);
            return null;
        }
    }
}

