/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.router.client;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.xnet.client.ControllerChannelClientInfo;
import mcjty.xnet.modules.router.RouterModule;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiRouter
extends GenericGuiContainer<TileEntityRouter, GenericContainer> {
    private WidgetList localChannelList;
    private WidgetList remoteChannelList;
    private boolean needsRefresh = true;
    private int listDirty;
    private static final ResourceLocation iconGuiElements = ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"textures/gui/guielements.png");

    public GuiRouter(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)RouterModule.ROUTER.block().get()).getManualEntry());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(RouterModule.CONTAINER_ROUTER.get(), GuiRouter::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.getBE(), ResourceLocation.fromNamespaceAndPath((String)"xnet", (String)"gui/router.gui"));
        super.init();
        this.localChannelList = (WidgetList)this.window.findChild("localchannels");
        this.remoteChannelList = (WidgetList)this.window.findChild("remotechannels");
        this.refresh();
        this.listDirty = 0;
    }

    private void updatePublish(BlockPos pos, int index, String name) {
        this.sendServerCommandTyped(TileEntityRouter.CMD_UPDATENAME, TypedMap.builder().put(TileEntityRouter.PARAM_POS, (Object)pos).put(TileEntityRouter.PARAM_CHANNEL, (Object)index).put(TileEntityRouter.PARAM_NAME, (Object)name).build());
    }

    private void refresh() {
        TileEntityRouter tileEntity = (TileEntityRouter)this.getBE();
        tileEntity.clientLocalChannels = null;
        tileEntity.clientRemoteChannels = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private boolean listsReady() {
        TileEntityRouter tileEntity = (TileEntityRouter)this.getBE();
        return tileEntity.clientLocalChannels != null && tileEntity.clientRemoteChannels != null;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.localChannelList.removeChildren();
        this.localChannelList.rowheight(40);
        int sel = this.localChannelList.getSelected();
        TileEntityRouter tileEntity = (TileEntityRouter)this.getBE();
        for (ControllerChannelClientInfo channel : tileEntity.clientLocalChannels) {
            this.localChannelList.children(new Widget[]{this.makeChannelLine(channel, true)});
        }
        this.localChannelList.selected(sel);
        this.remoteChannelList.removeChildren();
        this.remoteChannelList.rowheight(40);
        sel = this.remoteChannelList.getSelected();
        for (ControllerChannelClientInfo channel : tileEntity.clientRemoteChannels) {
            this.remoteChannelList.children(new Widget[]{this.makeChannelLine(channel, false)});
        }
        this.remoteChannelList.selected(sel);
    }

    private Panel makeChannelLine(ControllerChannelClientInfo channel, boolean local) {
        String name = channel.getChannelName();
        String publishedName = channel.getPublishedName();
        BlockPos controllerPos = channel.getPos();
        IChannelType type = channel.getChannelType();
        int index = channel.getIndex();
        Panel panel = (Panel)Widgets.positional().desiredHeight(30);
        Panel panel1 = (Panel)Widgets.horizontal((int)0, (int)0).hint(0, 0, 160, 13);
        int labelColor = -14531414;
        if (channel.isRemote()) {
            labelColor = -5631693;
        }
        panel1.children(new Widget[]{Widgets.label((String)"Ch").color(labelColor), Widgets.label((String)name), Widgets.label((String)">").color(labelColor)});
        if (channel.isRemote()) {
            panel1.children(new Widget[]{((ImageLabel)new ImageLabel().image(iconGuiElements, 48, 80)).desiredWidth(16)});
        }
        if (local) {
            TextField pubName = ((TextField)((TextField)new TextField().text(publishedName).desiredWidth(50)).desiredHeight(13)).event(newText -> this.updatePublish(controllerPos, index, newText));
            panel1.children(new Widget[]{pubName});
        } else {
            panel1.children(new Widget[]{Widgets.label((String)publishedName).color(-13369600)});
        }
        Panel panel2 = (Panel)((Panel)Widgets.horizontal((int)0, (int)0).hint(0, 13, 160, 13)).children(new Widget[]{Widgets.label((String)I18nConstants.POS_LABEL.i18n(new Object[0])).color(labelColor), Widgets.label((String)BlockPosTools.toString((BlockPos)controllerPos))});
        Panel panel3 = (Panel)((Panel)Widgets.horizontal((int)0, (int)0).hint(0, 26, 160, 13)).children(new Widget[]{Widgets.label((String)I18nConstants.INDEX_LABEL.i18n(new Object[0])).color(labelColor), Widgets.label((String)(index + " (" + type.getName() + ")"))});
        panel.children(new Widget[]{panel1, panel2, panel3});
        return panel;
    }

    private void requestListsIfNeeded() {
        TileEntityRouter tileEntity = (TileEntityRouter)this.getBE();
        if (tileEntity.clientLocalChannels != null && tileEntity.clientRemoteChannels != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)tileEntity.getBlockPos(), (String)TileEntityRouter.CMD_GETCHANNELS.name()));
            Networking.sendToServer((CustomPacketPayload)PacketGetListFromServer.create((BlockPos)tileEntity.getBlockPos(), (String)TileEntityRouter.CMD_GETREMOTECHANNELS.name()));
            this.listDirty = 10;
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.requestListsIfNeeded();
        this.populateList();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
    }
}

