/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.capability;

import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import thelm.packagedauto.api.IFluidStackWrapper;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.volume.FluidStackWrapper;

public class StackFluidHandlerItem
implements IFluidHandlerItem {
    protected ItemStack container;

    public StackFluidHandlerItem(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        IVolumeStackWrapper stack = (IVolumeStackWrapper)this.container.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK);
        if (stack instanceof IFluidStackWrapper) {
            IFluidStackWrapper fluid = (IFluidStackWrapper)stack;
            return fluid.getFluid();
        }
        return FluidStack.EMPTY;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null && !fluid.isEmpty()) {
            DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.VOLUME_PACKAGE_STACK.get(), (Object)FluidStackWrapper.of(fluid)).build();
            this.container.applyComponents(patch);
        }
    }

    protected void setContainerToEmpty() {
        this.container.shrink(1);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getFluid().getAmount();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (resource.getAmount() < this.getFluid().getAmount()) {
            return FluidStack.EMPTY;
        }
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (maxDrain < fluidStack.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

