/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.item.PackagedAutoItems;

public class WorldOverlayRenderer {
    public static final WorldOverlayRenderer INSTANCE = new WorldOverlayRenderer();
    public static final Vec3 BLOCK_SIZE = new Vec3(1.0, 1.0, 1.0);
    private Minecraft mc;
    private List<DirectionalMarkerInfo> directionalMarkers = new LinkedList<DirectionalMarkerInfo>();
    private List<SizedMarkerInfo> sizedMarkers = new LinkedList<SizedMarkerInfo>();
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private WorldOverlayRenderer() {
    }

    public void onConstruct() {
        this.mc = Minecraft.getInstance();
        NeoForge.EVENT_BUS.addListener(this::onClientTickPost);
        NeoForge.EVENT_BUS.addListener(this::onRenderLevel);
    }

    public void onRegisterRenderBuffers(RegisterRenderBuffersEvent event) {
        event.registerRenderBuffer(RenderTypeHelper.MARKER_LINE_4);
        event.registerRenderBuffer(RenderTypeHelper.MARKER_QUAD);
        event.registerRenderBuffer(RenderTypeHelper.BEAM_LINE_3);
    }

    public void onClientTickPost(ClientTickEvent.Post event) {
        if (this.mc.level == null || this.mc.player == null || this.mc.isPaused()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = this.mc.player.getItemInHand(hand);
            if (stack.is(PackagedAutoItems.DISTRIBUTOR_MARKER) && stack.has(PackagedAutoDataComponents.MARKER_POS)) {
                this.addDirectionalMarkers(List.of((DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS)), 65535, 1);
            }
            if (!stack.is(PackagedAutoItems.PROXY_MARKER) || !stack.has(PackagedAutoDataComponents.MARKER_POS)) continue;
            this.addDirectionalMarkers(List.of((DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS)), 0xFF7F00, 1);
        }
    }

    public void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        matrixStack.mul((Matrix4fc)event.getModelViewMatrix());
        RenderSystem.applyModelViewMatrix();
        this.render(event.getPoseStack(), event.getPartialTick());
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public void addDirectionalMarkers(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.directionalMarkers.add(new DirectionalMarkerInfo(positions, color, lifetime));
    }

    public void addSizedMarker(Vec3 lowerCorner, Vec3 size, int color, int lifetime) {
        this.sizedMarkers.add(new SizedMarkerInfo(lowerCorner, size, color, lifetime));
    }

    public void addBeams(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
        this.beams.add(new BeamInfo(source, deltas, color, lifetime, fadeout));
    }

    public void render(PoseStack poseStack, DeltaTracker deltaTracker) {
        int g;
        int r;
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.directionalMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.sizedMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + deltaTracker.getGameTimeDeltaPartialTick(true);
        Vec3 cameraPos = this.mc.gameRenderer.getMainCamera().getPosition();
        MultiBufferSource.BufferSource buffers = this.mc.renderBuffers().bufferSource();
        VertexConsumer quadBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_QUAD);
        VertexConsumer lineBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_LINE_4);
        for (DirectionalMarkerInfo directionalMarkerInfo : this.directionalMarkers) {
            int r2 = directionalMarkerInfo.color >> 16 & 0xFF;
            int g2 = directionalMarkerInfo.color >> 8 & 0xFF;
            int b = directionalMarkerInfo.color & 0xFF;
            for (DirectionalGlobalPos globalPos : directionalMarkerInfo.positions) {
                if (!globalPos.dimension().equals((Object)this.mc.level.dimension())) continue;
                int range = 64;
                BlockPos blockPos = globalPos.blockPos();
                Vec3 distVec = cameraPos.subtract(blockPos.getCenter());
                if (Doubles.max((double[])new double[]{Math.abs(distVec.x), Math.abs(distVec.y), Math.abs(distVec.z)}) > (double)range) continue;
                poseStack.pushPose();
                poseStack.translate((double)blockPos.getX() - cameraPos.x, (double)blockPos.getY() - cameraPos.y, (double)blockPos.getZ() - cameraPos.z);
                Direction direction = globalPos.direction();
                this.addMarkerVertices(poseStack, quadBuffer, BLOCK_SIZE, direction, r2, g2, b, 127);
                this.addMarkerVertices(poseStack, lineBuffer, BLOCK_SIZE, null, r2, g2, b, 255);
                poseStack.popPose();
            }
        }
        RenderSystem.disableDepthTest();
        buffers.endBatch();
        RenderSystem.enableDepthTest();
        lineBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_LINE_4);
        for (SizedMarkerInfo sizedMarkerInfo : this.sizedMarkers) {
            Vec3 lowerCorner = sizedMarkerInfo.lowerCorner;
            poseStack.pushPose();
            poseStack.translate(lowerCorner.x - cameraPos.x, lowerCorner.y - cameraPos.y, lowerCorner.z - cameraPos.z);
            r = sizedMarkerInfo.color >> 16 & 0xFF;
            g = sizedMarkerInfo.color >> 8 & 0xFF;
            int b = sizedMarkerInfo.color & 0xFF;
            this.addMarkerVertices(poseStack, lineBuffer, sizedMarkerInfo.size, null, r, g, b, 255);
            poseStack.popPose();
        }
        buffers.endBatch();
        lineBuffer = buffers.getBuffer(RenderTypeHelper.BEAM_LINE_3);
        for (BeamInfo beamInfo : this.beams) {
            Vec3 source = beamInfo.source;
            poseStack.pushPose();
            poseStack.translate(source.x - cameraPos.x, source.y - cameraPos.y, source.z - cameraPos.z);
            r = beamInfo.color >> 16 & 0xFF;
            g = beamInfo.color >> 8 & 0xFF;
            int b = beamInfo.color & 0xFF;
            int a = (int)(beamInfo.getAlpha(renderTick) * 255.0f);
            for (Vec3 delta : beamInfo.deltas) {
                this.addBeamVertices(poseStack, lineBuffer, delta, r, g, b, a);
            }
            poseStack.popPose();
        }
        buffers.endBatch();
    }

    public void addMarkerVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, Direction direction, int r, int g, int b, int a) {
        PoseStack.Pose pose = poseStack.last();
        float x = (float)delta.x;
        float y = (float)delta.y;
        float z = (float)delta.z;
        if (direction == null || direction == Direction.NORTH) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == null || direction == Direction.SOUTH) {
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
        }
        if (direction == null || direction == Direction.WEST) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
        }
        if (direction == null || direction == Direction.EAST) {
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
        }
        if (direction == Direction.DOWN) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.UP) {
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == null) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
        }
    }

    public void addBeamVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, int r, int g, int b, int a) {
        Vec3 normalVec = delta.normalize();
        PoseStack.Pose pose = poseStack.last();
        float x = (float)delta.x;
        float y = (float)delta.y;
        float z = (float)delta.z;
        float xn = (float)normalVec.x;
        float yn = (float)normalVec.y;
        float zn = (float)normalVec.z;
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, xn, yn, zn);
        buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, xn, yn, zn);
    }

    public static class RenderTypeHelper
    extends RenderType {
        public static final RenderType MARKER_LINE_4 = RenderTypeHelper.create((String)"packagedauto:marker_line_4", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setWriteMaskState(COLOR_WRITE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
        public static final RenderType MARKER_QUAD = RenderTypeHelper.create((String)"packagedauto:marker_quad", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1024, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setWriteMaskState(COLOR_WRITE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
        public static final RenderType BEAM_LINE_3 = RenderTypeHelper.create((String)"packagedauto:beam_line_3", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));

        private RenderTypeHelper(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }

    public record DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime, int startTick) {
        public DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime) {
            this(positions, color, lifetime, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public record SizedMarkerInfo(Vec3 lowerCorner, Vec3 size, int color, int lifetime, int startTick) {
        public SizedMarkerInfo(Vec3 lowerCorner, Vec3 size, int color, int lifetime) {
            this(lowerCorner, size, color, lifetime, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public record BeamInfo(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout, int startTick) {
        public BeamInfo(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
            this(source, deltas, color, lifetime, fadeout, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }

        public float getAlpha(float renderTick) {
            if (!this.fadeout) {
                return 1.0f;
            }
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = Math.min(diff / (float)this.lifetime, 1.0f);
            return 1.0f - factor * factor;
        }
    }
}

