/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.PackagerMenu;
import thelm.packagedauto.packet.ChangePackagingPacket;

public class PackagerScreen
extends BaseScreen<PackagerMenu> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/packager.png");

    public PackagerScreen(PackagerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void init() {
        this.clearWidgets();
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonChangePackaging(this.leftPos + 98, this.topPos + 16));
    }

    @Override
    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos + 102, this.topPos + 53, 176, 0, ((PackagerBlockEntity)((PackagerMenu)this.menu).blockEntity).getScaledProgress(22), 16);
        int scaledEnergy = ((PackagerBlockEntity)((PackagerMenu)this.menu).blockEntity).getScaledEnergy(40);
        graphics.blit(BACKGROUND, this.leftPos + 10, this.topPos + 10 + 40 - scaledEnergy, 176, 56 - scaledEnergy, 12, scaledEnergy);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        String s = ((PackagerBlockEntity)((PackagerMenu)this.menu).blockEntity).getDisplayName().getString();
        graphics.drawString(this.font, s, this.imageWidth / 2 - this.font.width(s) / 2, 6, 0x404040, false);
        graphics.drawString(this.font, ((PackagerMenu)this.menu).inventory.getDisplayName().getString(), ((PackagerMenu)this.menu).getPlayerInvX(), ((PackagerMenu)this.menu).getPlayerInvY() - 11, 0x404040, false);
        if (mouseX - this.leftPos >= 10 && mouseY - this.topPos >= 10 && mouseX - this.leftPos <= 21 && mouseY - this.topPos <= 49) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)(((PackagerBlockEntity)((PackagerMenu)this.menu).blockEntity).getEnergyStorage().getEnergyStored() + " / " + ((PackagerBlockEntity)((PackagerMenu)this.menu).blockEntity).getEnergyStorage().getMaxEnergyStored() + " FE")), mouseX - this.leftPos, mouseY - this.topPos);
        }
        super.renderLabels(graphics, mouseX, mouseY);
    }

    class ButtonChangePackaging
    extends AbstractButton {
        final Tooltip exactTooltip;
        final Tooltip disjointTooltip;
        final Tooltip firstTooltip;

        public ButtonChangePackaging(int x, int y) {
            super(x, y, 16, 18, (Component)Component.empty());
            this.exactTooltip = Tooltip.create((Component)PackagerBlockEntity.Mode.EXACT.getTooltip());
            this.disjointTooltip = Tooltip.create((Component)PackagerBlockEntity.Mode.DISJOINT.getTooltip());
            this.firstTooltip = Tooltip.create((Component)PackagerBlockEntity.Mode.FIRST.getTooltip());
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.setTooltip(this.currentTooltip());
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(BACKGROUND, this.getX() + 1, this.getY() + 2, 176, 56 + 14 * ((PackagerBlockEntity)((PackagerMenu)PackagerScreen.this.menu).blockEntity).mode.ordinal(), 14, 14);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)ChangePackagingPacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        private Tooltip currentTooltip() {
            return switch (((PackagerBlockEntity)((PackagerMenu)PackagerScreen.this.menu).blockEntity).mode) {
                default -> throw new MatchException(null, null);
                case PackagerBlockEntity.Mode.EXACT -> this.exactTooltip;
                case PackagerBlockEntity.Mode.DISJOINT -> this.disjointTooltip;
                case PackagerBlockEntity.Mode.FIRST -> this.firstTooltip;
            };
        }
    }
}

