/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.recipe.DirectCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;
import thelm.packagedauto.util.MiscHelper;

public class AEPackagingProviderBlockEntity
extends PackagingProviderBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEPackagingProviderBlockEntity>,
IActionHost,
ICraftingProvider {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;
    public int roundRobinIndex = 0;

    public AEPackagingProviderBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.level, this.worldPosition);
            this.postPatternChange();
        }
        super.tick();
        if (this.currentPattern != null) {
            this.sendPackaging();
        }
        if (!this.toSend.isEmpty()) {
            this.sendUnpackaging();
        }
    }

    protected void sendPackaging() {
        if (this.currentPattern == null) {
            return;
        }
        if (this.getMainNode().isActive()) {
            AEItemKey key;
            MEStorage inventory;
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)(inventory = storageService.getInventory()), (AEKey)(key = AEItemKey.of((ItemStack)this.currentPattern.getOutput())), (long)1L, (IActionSource)this.source, (Actionable)Actionable.MODULATE);
            if (inserted == 1) {
                this.currentPattern = null;
            }
        }
    }

    protected void sendUnpackaging() {
        if (this.toSend.isEmpty()) {
            return;
        }
        if (this.sendDirection != null) {
            BlockPos offsetPos = this.worldPosition.relative(this.sendDirection);
            BlockEntity blockEntity = this.level.getBlockEntity(offsetPos);
            if (!this.validSendTarget(blockEntity, this.sendDirection.getOpposite())) {
                this.sendDirection = null;
                return;
            }
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)this.sendDirection.getOpposite());
            for (int i = 0; i < this.toSend.size(); ++i) {
                ItemStack stack;
                ItemStack stackRem = stack = (ItemStack)this.toSend.get(i);
                if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, this.sendDirection.getOpposite())) {
                    stackRem = MiscHelper.INSTANCE.fillVolume(this.level, offsetPos, this.sendDirection.getOpposite(), stack, false);
                } else if (itemHandler != null) {
                    stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, this.sendOrdered, false);
                }
                this.toSend.set(i, stackRem);
            }
            this.toSend.removeIf(ItemStack::isEmpty);
            this.setChanged();
        } else if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            for (int i = 0; i < this.toSend.size(); ++i) {
                int count;
                ItemStack is = (ItemStack)this.toSend.get(i);
                if (is.isEmpty()) continue;
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.getCount()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.toSend.set(i, ItemStack.EMPTY);
                    continue;
                }
                this.toSend.set(i, key.toStack(count - inserted));
            }
            this.toSend.removeIf(ItemStack::isEmpty);
            this.setChanged();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEPackagingProviderBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public void onStateChanged(AEPackagingProviderBlockEntity nodeOwner, IGridNode node, IGridNodeListener.State state) {
        if (state == IGridNodeListener.State.POWER || state == IGridNodeListener.State.CHANNEL) {
            this.postPatternChange();
        }
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)this);
            this.gridNode.setTagName("node");
            this.gridNode.setVisualRepresentation(PackagedAutoBlocks.PACKAGING_PROVIDER);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridNode.addService(ICraftingProvider.class, (IGridNodeService)this);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (this.getMainNode().isActive() && !this.isBusy()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnit.FE.convertTo(PowerUnit.AE, 1.0);
            IPackageRecipeInfo recipe = null;
            if (patternDetails instanceof DirectCraftingPatternDetails) {
                DirectCraftingPatternDetails pattern = (DirectCraftingPatternDetails)patternDetails;
                recipe = pattern.recipe;
            } else if (patternDetails instanceof RecipeCraftingPatternDetails) {
                RecipeCraftingPatternDetails pattern = (RecipeCraftingPatternDetails)patternDetails;
                recipe = pattern.recipe;
            } else if (patternDetails instanceof PackageCraftingPatternDetails) {
                PackageCraftingPatternDetails pattern = (PackageCraftingPatternDetails)patternDetails;
                double request = (double)(PackagerBlockEntity.energyReq * 2) * conversion;
                if (request - energyService.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                energyService.extractAEPower(request, Actionable.MODULATE, PowerMultiplier.CONFIG);
                this.currentPattern = pattern.pattern;
                return true;
            }
            if (recipe != null) {
                double request = (double)(PackagerBlockEntity.energyReq * 2 + UnpackagerBlockEntity.energyUsage) * conversion;
                if (request - energyService.extractAEPower(request, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4) {
                    return false;
                }
                if (recipe.getRecipeType().hasMachine()) {
                    ArrayList directions = Lists.newArrayList((Object[])Direction.values());
                    Collections.rotate(directions, this.roundRobinIndex);
                    for (Direction direction : Direction.values()) {
                        IPackageCraftingMachine machine;
                        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction));
                        if (!(blockEntity instanceof IPackageCraftingMachine) || (machine = (IPackageCraftingMachine)blockEntity).isBusy() || !machine.acceptPackage(recipe, Lists.transform(recipe.getInputs(), ItemStack::copy), direction.getOpposite(), this.blocking)) continue;
                        energyService.extractAEPower(request, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                        return true;
                    }
                    return false;
                }
                ArrayList toSend = new ArrayList();
                recipe.getInputs().stream().map(ItemStack::copy).forEach(toSend::add);
                ArrayList directions = Lists.newArrayList((Object[])Direction.values());
                Collections.rotate(directions, this.roundRobinIndex);
                block1: for (Direction direction : directions) {
                    BlockPos offsetPos = this.worldPosition.relative(direction);
                    BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(direction));
                    if (!this.validSendTarget(blockEntity, direction.getOpposite())) continue;
                    IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
                    if (this.blocking) {
                        for (int i = 0; i < toSend.size(); ++i) {
                            ItemStack stack = (ItemStack)toSend.get(i);
                            if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, direction.getOpposite()) ? !((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().isEmpty(this.level, offsetPos, direction.getOpposite()) : itemHandler != null && !MiscHelper.INSTANCE.isEmpty(itemHandler)) continue block1;
                        }
                    }
                    boolean acceptsAll = true;
                    for (int i = 0; i < toSend.size(); ++i) {
                        ItemStack stack;
                        ItemStack stackRem = stack = (ItemStack)toSend.get(i);
                        if (stack.has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && ((IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType().hasBlockCapability(this.level, offsetPos, direction.getOpposite())) {
                            stackRem = MiscHelper.INSTANCE.fillVolume(this.level, offsetPos, direction.getOpposite(), stack, true);
                        } else if (itemHandler != null) {
                            stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, false, true);
                        }
                        acceptsAll &= stackRem.getCount() < stack.getCount();
                    }
                    if (!acceptsAll) continue;
                    energyService.extractAEPower(request, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.sendDirection = direction;
                    this.toSend.addAll(toSend);
                    this.sendOrdered = recipe.getRecipeType().isOrdered();
                    this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                    this.sendUnpackaging();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected boolean validSendTarget(BlockEntity blockEntity, Direction direction) {
        return blockEntity == null || !(blockEntity instanceof IPackageCraftingMachine) && !(blockEntity instanceof PackagerBlockEntity) && !(blockEntity instanceof PackagerExtensionBlockEntity) && !(blockEntity instanceof UnpackagerBlockEntity) && !AppEngUtil.isPatternProvider(blockEntity, direction);
    }

    public boolean isBusy() {
        return this.powered || this.currentPattern != null || !this.toSend.isEmpty();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        if (this.getMainNode().isActive()) {
            ArrayList<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
            RegistryAccess registry = this.level.registryAccess();
            if (this.provideDirect) {
                this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new DirectCraftingPatternDetails((IPackageRecipeInfo)pattern, (HolderLookup.Provider)registry)).forEach(patterns::add);
            }
            if (this.providePackaging) {
                this.recipeList.stream().filter(IPackageRecipeInfo::isValid).flatMap(recipe -> Streams.concat((Stream[])new Stream[]{recipe.getPatterns().stream(), recipe.getExtraPatterns().stream()})).map(pattern -> new PackageCraftingPatternDetails((IPackagePattern)pattern, (HolderLookup.Provider)registry)).forEach(patterns::add);
            }
            if (this.provideUnpackaging) {
                this.recipeList.stream().filter(pattern -> !pattern.getOutputs().isEmpty()).map(pattern -> new RecipeCraftingPatternDetails((IPackageRecipeInfo)pattern, (HolderLookup.Provider)registry)).forEach(patterns::add);
            }
            return patterns;
        }
        return List.of();
    }

    @Override
    public void postPatternChange() {
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

