/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.PatternType;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class RecipeCraftingPatternDetails
implements IPatternDetails {
    public final IPackageRecipeInfo recipe;
    public final AEItemKey definition;
    public final IPatternDetails.IInput[] inputs;
    public final List<GenericStack> outputs;

    public RecipeCraftingPatternDetails(IPackageRecipeInfo recipe, HolderLookup.Provider registries) {
        this.recipe = recipe;
        ItemStack definitionStack = recipe.getPatterns().get(0).getOutput();
        DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)PackagedAutoDataComponents.PATTERN_TYPE.get(), (Object)PatternType.RECIPE).build();
        definitionStack.applyComponents(patch);
        this.definition = AEItemKey.of((ItemStack)definitionStack);
        List<GenericStack> sparseInputs = recipe.getPatterns().stream().map(IPackagePattern::getOutput).map(GenericStack::fromItemStack).toList();
        List<GenericStack> sparseOutputs = recipe.getOutputs().stream().map(o -> AppEngUtil.getGenericOutput(o, registries)).toList();
        this.inputs = AppEngUtil.toInputs(sparseInputs, registries);
        this.outputs = AppEngUtil.condenseStacks(sparseOutputs);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public List<GenericStack> getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeCraftingPatternDetails) {
            RecipeCraftingPatternDetails other = (RecipeCraftingPatternDetails)obj;
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return this.recipe.hashCode();
    }
}

