/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.util.MiscHelper;

public class BaseItemHandler<T extends BaseBlockEntity>
extends ItemStackHandler
implements ContainerData {
    public final T blockEntity;
    protected Map<Direction, IItemHandlerModifiable> wrapperMap = new IdentityHashMap<Direction, IItemHandlerModifiable>(7);

    public BaseItemHandler(T blockEntity, int size) {
        super(size);
        this.blockEntity = blockEntity;
    }

    public List<ItemStack> getStacks() {
        return Collections.unmodifiableList(this.stacks);
    }

    protected void onContentsChanged(int slot) {
        if (this.blockEntity != null) {
            this.blockEntity.setChanged();
        }
    }

    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        this.stacks.clear();
        MiscHelper.INSTANCE.loadAllItems(nbt.getList("items", 10), (List<ItemStack>)this.stacks, "slot", registries);
    }

    public void save(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put("items", (Tag)MiscHelper.INSTANCE.saveAllItems(new ListTag(), (List<ItemStack>)this.stacks, "slot", registries));
    }

    public void setChanged() {
        if (this.blockEntity != null) {
            this.blockEntity.setChanged();
        }
    }

    public void sync(boolean rerender) {
        if (this.blockEntity != null) {
            ((BaseBlockEntity)((Object)this.blockEntity)).sync(rerender);
        }
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this;
    }

    public int get(int index) {
        return 0;
    }

    public void set(int index, int value) {
    }

    public int getCount() {
        return 0;
    }
}

