/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.device.TileFluxDevice;

@OnlyIn(value=Dist.CLIENT)
public class FluxColorHandler
implements BlockColor,
ItemColor {
    public static final FluxColorHandler INSTANCE = new FluxColorHandler();

    public int getColor(@Nonnull BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        BlockEntity tile;
        if (tintIndex == 1 && pos != null && world != null && (tile = world.getBlockEntity(pos)) instanceof TileFluxDevice) {
            return ((TileFluxDevice)tile).mClientColor;
        }
        return -1;
    }

    public int getColor(@Nonnull ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            return FluxColorHandler.getColorForItem(stack);
        }
        return -1;
    }

    public static int colorMultiplierForConfigurator(ItemStack stack, int tintIndex) {
        return tintIndex == 1 ? FastColor.ARGB32.opaque((int)FluxColorHandler.getColorForItem(stack)) : -1;
    }

    public static int getColorForItem(ItemStack stack) {
        Optional forcedColor = (Optional)stack.get(FluxDataComponents.FLUX_COLOR);
        if (forcedColor != null && forcedColor.isPresent()) {
            return (Integer)forcedColor.get();
        }
        FluxDeviceConfigComponent data = (FluxDeviceConfigComponent)stack.get(FluxDataComponents.FLUX_CONFIG);
        if (data != null) {
            return ClientCache.getNetwork(data.networkId()).getNetworkColor();
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof GuiFluxCore) {
            GuiFluxCore gui = (GuiFluxCore)screen;
            return gui.getNetwork().getNetworkColor();
        }
        return 0xB2B2B2;
    }
}

