/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import sonar.fluxnetworks.client.render.FluxStorageRenderType;
import sonar.fluxnetworks.common.device.TileFluxStorage;

public class FluxStorageEntityRenderer
implements BlockEntityRenderer<TileFluxStorage> {
    private static final FluxStorageEntityRenderer INSTANCE = new FluxStorageEntityRenderer();
    public static final BlockEntityRendererProvider<TileFluxStorage> PROVIDER = INSTANCE::onContextChanged;
    private static final float START = 0.125f;
    private static final float END = 0.875f;
    private static final float OFFSET = 0.0625f;
    private static final float WIDTH = 0.75f;
    private static final float HEIGHT = 0.8125f;
    private static final int ALPHA = 150;

    private FluxStorageEntityRenderer() {
    }

    @Nonnull
    private FluxStorageEntityRenderer onContextChanged(@Nonnull BlockEntityRendererProvider.Context context) {
        return this;
    }

    public void render(@Nonnull TileFluxStorage entity, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluxStorageEntityRenderer.render(poseStack, bufferSource.getBuffer(FluxStorageRenderType.getType()), entity.mClientColor, packedOverlay, entity.getTransferBuffer(), entity.getMaxTransferLimit());
    }

    static void render(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer consumer, int color, int overlay, long energy, long capacity) {
        if (energy <= 0L || capacity <= 0L) {
            return;
        }
        float renderHeight = Math.min(0.8125f * (float)energy / (float)capacity, 0.8125f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        FluxStorageEntityRenderer.renderSide(poseStack, consumer, Direction.NORTH, 0.125f, 0.0625f, 0.875f, 0.75f, renderHeight, r, g, b, overlay, -1);
        FluxStorageEntityRenderer.renderSide(poseStack, consumer, Direction.SOUTH, 0.125f, 0.0625f, 0.875f, 0.75f, renderHeight, r, g, b, overlay, -1);
        FluxStorageEntityRenderer.renderSide(poseStack, consumer, Direction.EAST, 0.125f, 0.0625f, 0.875f, 0.75f, renderHeight, r, g, b, overlay, -1);
        FluxStorageEntityRenderer.renderSide(poseStack, consumer, Direction.WEST, 0.125f, 0.0625f, 0.875f, 0.75f, renderHeight, r, g, b, overlay, -1);
        if (renderHeight < 0.8125f) {
            FluxStorageEntityRenderer.renderSide(poseStack, consumer, Direction.UP, 0.0625f, 0.125f + renderHeight, 0.0625f, 0.875f, -0.875f, r, g, b, overlay, 1);
        }
    }

    private static void renderSide(@Nonnull PoseStack stack, @Nonnull VertexConsumer consumer, @Nonnull Direction dir, float x, float y, float z, float width, float height, int r, int g, int b, int overlay, int normalY) {
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        stack.mulPose(dir.getRotation());
        stack.translate(-0.5, -0.5, -0.5);
        Matrix4f pose = stack.last().pose();
        PoseStack.Pose normal = stack.last();
        consumer.addVertex(pose, x, y, z - height).setColor(r, g, b, 150).setUv(x, z - height).setOverlay(overlay).setLight(0xF000F0).setNormal(normal, 0.0f, (float)normalY, 0.0f);
        consumer.addVertex(pose, x + width, y, z - height).setColor(r, g, b, 150).setUv(x + width, z - height).setOverlay(overlay).setLight(0xF000F0).setNormal(normal, 0.0f, (float)normalY, 0.0f);
        consumer.addVertex(pose, x + width, y, z).setColor(r, g, b, 150).setUv(x + width, z).setOverlay(overlay).setLight(0xF000F0).setNormal(normal, 0.0f, (float)normalY, 0.0f);
        consumer.addVertex(pose, x, y, z).setColor(r, g, b, 150).setUv(x, z).setOverlay(overlay).setLight(0xF000F0).setNormal(normal, 0.0f, (float)normalY, 0.0f);
        stack.popPose();
    }
}

