/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.extensions;

import com.sammy.malum.client.cosmetic.ArmorSkinRenderingData;
import com.sammy.malum.common.data.component.ItemSkinComponent;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class ArmorClientItemExtensions
implements IClientItemExtensions {
    private final Supplier<LodestoneArmorModel> model;

    public ArmorClientItemExtensions(Supplier<LodestoneArmorModel> model) {
        this.model = model;
    }

    public LodestoneArmorModel getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel _default) {
        float pticks = Minecraft.getInstance().getFrameTimeNs() / 20000000000L;
        float f = Mth.rotLerp((float)pticks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float f1 = Mth.rotLerp((float)pticks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float netHeadYaw = f1 - f;
        float netHeadPitch = Mth.lerp((float)pticks, (float)entity.xRotO, (float)entity.getXRot());
        LodestoneArmorModel model = this.model.get();
        ItemSkinComponent skin = (ItemSkinComponent)itemStack.get(MalumDataComponents.APPLIED_ITEM_SKIN);
        if (skin != null && ArmorSkinRenderingData.ARMOR_RENDERING_DATA.containsKey(skin)) {
            model = ArmorSkinRenderingData.ARMOR_RENDERING_DATA.get(skin).getModel(entity);
        }
        model.slot = armorSlot;
        model.copyFromDefault(_default);
        model.setupAnim(entity, entity.walkAnimation.position(), entity.walkAnimation.speed(), (float)entity.tickCount + pticks, netHeadYaw, netHeadPitch);
        return model;
    }
}

