/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.model.cosmetic.ultrakill;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sammy.malum.MalumMod;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import team.lodestar.lodestone.systems.model.LodestoneArmorModel;

public class UltrakillMachineArmorModel
extends LodestoneArmorModel {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(MalumMod.malumPath("ultrakill_machine"), "main");
    public ModelPart wings;
    public ModelPart wingsFullBright;
    public ModelPart helmetFullBright;

    public UltrakillMachineArmorModel(ModelPart root) {
        super(root);
        this.wings = root.getChild("wings");
        this.wingsFullBright = root.getChild("wings_full_bright");
        this.helmetFullBright = root.getChild("helmet_full_bright");
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
        if (!this.young) {
            if (this.slot == EquipmentSlot.CHEST) {
                this.wingsFullBright.render(poseStack, buffer, 0xF000F0, packedOverlay, color);
            }
            if (this.slot == EquipmentSlot.HEAD) {
                this.helmetFullBright.render(poseStack, buffer, 0xF000F0, packedOverlay, color);
            }
        }
    }

    protected Iterable<ModelPart> bodyParts() {
        if (this.slot == EquipmentSlot.CHEST) {
            return ImmutableList.of((Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.wings);
        }
        if (this.slot == EquipmentSlot.LEGS) {
            return ImmutableList.of((Object)this.leftLegging, (Object)this.rightLegging, (Object)this.leggings);
        }
        return this.slot == EquipmentSlot.FEET ? ImmutableList.of((Object)this.leftFoot, (Object)this.rightFoot) : ImmutableList.of();
    }

    public void copyFromDefault(HumanoidModel model) {
        super.copyFromDefault(model);
        this.wings.copyFrom(model.body);
        this.wingsFullBright.copyFrom(model.body);
        this.helmetFullBright.copyFrom(model.head);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.0f), (float)0.0f);
        PartDefinition root = UltrakillMachineArmorModel.createHumanoidAlias((MeshDefinition)mesh);
        PartDefinition wings = root.addOrReplaceChild("wings", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition wingsFullBright = root.addOrReplaceChild("wings_full_bright", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition helmetFullBright = root.addOrReplaceChild("helmet_full_bright", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition body = root.getChild("body");
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(24, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.95f)).texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_legging = root.getChild("right_legging");
        PartDefinition right_leg = right_legging.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.45f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_foot = root.getChild("right_foot");
        PartDefinition right_boot = right_foot.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(32, 44).addBox(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.25f)).texOffs(32, 32).addBox(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = root.getChild("right_arm");
        PartDefinition right_shoulder = right_arm.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).texOffs(16, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_legging = root.getChild("left_legging");
        PartDefinition left_leg = left_legging.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.45f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot = root.getChild("left_foot");
        PartDefinition left_boot = left_foot.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(32, 44).mirror().addBox(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.26f)).mirror(false).texOffs(32, 32).mirror().addBox(-3.0f, 7.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = root.getChild("left_arm");
        PartDefinition left_shoulder = left_arm.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).mirror(false).texOffs(16, 32).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.getChild("head");
        PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.95f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition helmet_full_bright = helmetFullBright.addOrReplaceChild("helmet_full_bright", CubeListBuilder.create().texOffs(10, 10).addBox(-2.0f, -6.0f, -4.25f, 4.0f, 4.0f, 0.0f, new CubeDeformation(0.251f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition l1 = wings.addOrReplaceChild("l1", CubeListBuilder.create().texOffs(16, 48).addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 48).mirror().addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(16, 51).addBox(6.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(6.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.1745f, (float)-0.6981f));
        PartDefinition l2 = wings.addOrReplaceChild("l2", CubeListBuilder.create().texOffs(16, 48).addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 48).mirror().addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(16, 51).addBox(6.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(6.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition l3 = wings.addOrReplaceChild("l3", CubeListBuilder.create().texOffs(16, 48).addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 48).mirror().addBox(3.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(16, 51).addBox(6.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(6.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.0873f, (float)0.6981f));
        PartDefinition r1 = wings.addOrReplaceChild("r1", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 48).addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(16, 51).mirror().addBox(-9.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 51).mirror().addBox(-9.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.1745f, (float)0.6981f));
        PartDefinition r2 = wings.addOrReplaceChild("r2", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 48).addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(16, 51).mirror().addBox(-9.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 51).mirror().addBox(-9.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition r3 = wings.addOrReplaceChild("r3", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 48).addBox(-6.0f, -1.0f, -1.0f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.25f)).texOffs(16, 51).mirror().addBox(-9.0f, -4.0f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(24, 51).mirror().addBox(-9.0f, -4.25f, -1.0f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.0873f, (float)-0.6981f));
        PartDefinition l4 = wingsFullBright.addOrReplaceChild("l4", CubeListBuilder.create().texOffs(16, 57).mirror().addBox(6.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.1745f, (float)-0.6981f));
        PartDefinition l5 = wingsFullBright.addOrReplaceChild("l5", CubeListBuilder.create().texOffs(16, 57).mirror().addBox(7.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition l6 = wingsFullBright.addOrReplaceChild("l6", CubeListBuilder.create().texOffs(16, 57).mirror().addBox(6.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)-0.0873f, (float)0.6981f));
        PartDefinition r4 = wingsFullBright.addOrReplaceChild("r4", CubeListBuilder.create().texOffs(16, 57).addBox(-19.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.1745f, (float)0.6981f));
        PartDefinition r5 = wingsFullBright.addOrReplaceChild("r5", CubeListBuilder.create().texOffs(16, 57).addBox(-19.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition r6 = wingsFullBright.addOrReplaceChild("r6", CubeListBuilder.create().texOffs(16, 57).addBox(-19.0f, -3.5f, -0.5f, 12.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)5.0f, (float)0.0f, (float)0.0873f, (float)-0.6981f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

