/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlock;
import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlockEntity;
import com.sammy.malum.common.data.component.SoulwovenBannerPatternDataComponent;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class SoulwovenBannerRenderer
implements BlockEntityRenderer<SoulwovenBannerBlockEntity> {
    public SoulwovenBannerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SoulwovenBannerBlockEntity blockEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockState = blockEntityIn.getBlockState();
        SoulwovenBannerPatternDataComponent patternData = blockEntityIn.patternData;
        RenderTypeToken token = RenderTypeToken.createToken((ResourceLocation)patternData.texturePath());
        LodestoneRenderType banner = LodestoneRenderTypes.CUTOUT_TEXTURE.applyWithModifierAndCache(token, b -> b.setCullState(RenderStateShard.NO_CULL));
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType((RenderType)banner).setLight(combinedLightIn);
        BlockPos pos = blockEntityIn.getBlockPos();
        MalumSpiritType spirit = blockEntityIn.spirit;
        SoulwovenBannerBlock.BannerType type = (SoulwovenBannerBlock.BannerType)((Object)blockState.getValue(SoulwovenBannerBlock.BANNER_TYPE));
        Direction direction = type.direction.getAxis().isVertical() ? (type.equals((Object)SoulwovenBannerBlock.BannerType.HANGING_Z) ? Direction.NORTH : Direction.WEST) : type.direction;
        float sway = ((float)Math.floorMod((long)pos.getX() * 7L + (long)pos.getY() * 9L + (long)pos.getZ() * 13L + blockEntityIn.getLevel().getGameTime(), 100L) + partialTicks) / 100.0f;
        float swayRotation = 0.01f * Mth.cos((float)((float)Math.PI * 2 * sway)) * (float)Math.PI;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(direction.toYRot()));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        if (type.direction.getAxis().isHorizontal()) {
            poseStack.translate(0.0f, -0.25f, 0.0625f);
            swayRotation -= 0.0125f;
        } else {
            poseStack.translate(0.0f, 0.0f, 0.5f);
            swayRotation -= 0.0157f;
        }
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotation(swayRotation));
        float xStart = 0.0f;
        float xEnd = 1.0f;
        float yStart = -2.0f;
        float yEnd = 0.0f;
        Vector3f[] vertices = new Vector3f[]{new Vector3f(xEnd, yStart, 0.0f), new Vector3f(xStart, yStart, 0.0f), new Vector3f(xStart, yEnd, 0.0f), new Vector3f(xEnd, yEnd, 0.0f)};
        builder.renderQuad(poseStack, vertices, 1.0f);
        if (spirit != null) {
            LodestoneRenderType spiritGlow = blockEntityIn.intense ? LodestoneRenderTypes.ADDITIVE_TEXTURE.applyWithModifierAndCache(token, b -> b.setCullState(RenderStateShard.NO_CULL)) : LodestoneRenderTypes.ADDITIVE_TEXTURE.applyWithModifierAndCache(token, ShaderUniformHandler.LUMITRANSPARENT, b -> b.setCullState(RenderStateShard.NO_CULL));
            VFXBuilders.WorldVFXBuilder spiritBuilder = VFXBuilders.createWorld().setRenderType((RenderType)spiritGlow).setColor(spirit.getPrimaryColor());
            for (int i = 1; i < 4; ++i) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 0.001f * (float)i);
                spiritBuilder.setAlpha(0.9f).renderQuad(poseStack, vertices, 1.0f);
                poseStack.translate(0.0f, 0.0f, -0.002f * (float)i);
                spiritBuilder.setAlpha(0.9f).renderQuad(poseStack, vertices, 1.0f);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(SoulwovenBannerBlockEntity altar) {
        BlockPos pos = altar.getBlockPos();
        return new AABB((double)pos.getX(), (double)(pos.getY() - 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
    }
}

