/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.curio;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.cosmetic.curios.CurioTokenOfGratitude;
import com.sammy.malum.registry.client.MalumModels;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.rendeertype.RenderTypeToken;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class TokenOfGratitudeRenderer
implements ICurioRenderer {
    private static final ResourceLocation SAMMY = MalumMod.malumPath("textures/cosmetic/sammy_tail.png");
    private static final ResourceLocation OWL_PERSON_EYES = MalumMod.malumPath("textures/cosmetic/owl_person_eyes.png");
    private static final ResourceLocation OWL_PERSON_ELYTRA = MalumMod.malumPath("textures/cosmetic/owl_person_elytra.png");
    private static final ResourceLocation SNAKE_FELLA_SCARF = MalumMod.malumPath("textures/cosmetic/snake_scarf.png");
    private static final ResourceLocation BOBBU_SCARF = MalumMod.malumPath("textures/cosmetic/bobbu_scarf.png");
    private static final ResourceLocation DELLY_NECKLACE = MalumMod.malumPath("textures/cosmetic/delly_necklace.png");
    private static final ResourceLocation LOFI = MalumMod.malumPath("textures/cosmetic/lofi_tail.png");
    private static final ResourceLocation TRANS_SCARF = MalumMod.malumPath("textures/cosmetic/trans_scarf.png");

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer playerEntity = (AbstractClientPlayer)livingEntity;
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.SAMMY)) {
                TokenOfGratitudeRenderer.renderTail(stack, SAMMY, poseStack, playerEntity, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.LOFI) || playerEntity.getUUID().equals(CurioTokenOfGratitude.CREECHURE)) {
                TokenOfGratitudeRenderer.renderTail(stack, LOFI, poseStack, playerEntity, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.OWL_PERSON)) {
                TokenOfGratitudeRenderer.renderGlowingEyes(playerEntity, (RenderType)LodestoneRenderTypes.TRANSPARENT_TEXTURE.apply(RenderTypeToken.createToken((ResourceLocation)OWL_PERSON_EYES)), poseStack, renderTypeBuffer, 0xF000F0);
            }
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.SNAKE_SCARF_FELLA)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, SNAKE_FELLA_SCARF, poseStack, renderTypeBuffer, light);
            }
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.BOBBU)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, BOBBU_SCARF, poseStack, renderTypeBuffer, light);
            }
            if (playerEntity.getUUID().equals(CurioTokenOfGratitude.DELLY)) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, DELLY_NECKLACE, poseStack, renderTypeBuffer, light);
            }
            if (CurioTokenOfGratitude.TRANS_SCARFS.contains(playerEntity.getUUID())) {
                TokenOfGratitudeRenderer.renderScarf(playerEntity, TRANS_SCARF, poseStack, renderTypeBuffer, light);
            }
        }
    }

    public static ResourceLocation getElytraTexture(UUID uuid, ResourceLocation original) {
        if (uuid.equals(CurioTokenOfGratitude.OWL_PERSON)) {
            return OWL_PERSON_ELYTRA;
        }
        return original;
    }

    public static void renderGlowingEyes(AbstractClientPlayer playerEntity, RenderType renderType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        VertexConsumer vertexconsumer = renderTypeBuffer.getBuffer(renderType);
        ICurioRenderer.followHeadRotations((LivingEntity)playerEntity, (ModelPart[])new ModelPart[]{MalumModels.HEAD_OVERLAY_MODEL.overlay});
        MalumModels.HEAD_OVERLAY_MODEL.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
    }

    public static void renderTail(ItemStack stack, ResourceLocation texture, PoseStack poseStack, AbstractClientPlayer playerEntity, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        poseStack.pushPose();
        Vec3 movement = new Vec3(playerEntity.getDeltaMovement().x, 0.0, playerEntity.getDeltaMovement().z);
        double wagSpeed = playerEntity.getDeltaMovement().length();
        if (wagSpeed != 0.0) {
            double factor = 55.0;
            Vec3 yawLook = Vec3.directionFromRotation((float)0.0f, (float)playerEntity.getYRot());
            Vec3 look = new Vec3(yawLook.x, 0.0, yawLook.z);
            Vec3 desiredDirection = look.yRot((float)Math.toRadians(90.0)).normalize();
            Vec3 sidewaysVelocity = desiredDirection.scale(movement.dot(desiredDirection));
            double speedAndDirection = sidewaysVelocity.length() * -Math.signum(desiredDirection.dot(sidewaysVelocity)) / wagSpeed;
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(speedAndDirection * factor)));
        }
        float ambientFactor = playerEntity.isShiftKeyDown() ? 2.0f : 6.0f;
        double ambientXRotation = Math.sin((float)playerEntity.level().getGameTime() / 18.0f) * (double)ambientFactor;
        poseStack.mulPose(Axis.XP.rotationDegrees((float)ambientXRotation));
        double ambientYRotation = Math.cos((float)playerEntity.level().getGameTime() / 24.0f) * (double)(-ambientFactor);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)ambientYRotation));
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)texture), (boolean)stack.hasFoil());
        MalumModels.TAIL_MODEL.setupAnim((Player)playerEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        MalumModels.TAIL_MODEL.prepareMobModel((Entity)playerEntity, limbSwing, limbSwingAmount, partialTicks);
        ICurioRenderer.translateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
        ICurioRenderer.rotateIfSneaking((PoseStack)poseStack, (LivingEntity)playerEntity);
        MalumModels.TAIL_MODEL.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
        poseStack.popPose();
    }

    public static void renderScarf(AbstractClientPlayer playerEntity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light) {
        LivingEntityRenderer livingEntityRenderer;
        EntityModel model;
        VertexConsumer vertexconsumer = renderTypeBuffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texture));
        float pticks = Minecraft.getInstance().timer.getGameTimeDeltaTicks();
        float f = Mth.rotLerp((float)pticks, (float)playerEntity.yBodyRotO, (float)playerEntity.yBodyRot);
        float f1 = Mth.rotLerp((float)pticks, (float)playerEntity.yHeadRotO, (float)playerEntity.yHeadRot);
        float netHeadYaw = f1 - f;
        float netHeadPitch = Mth.lerp((float)pticks, (float)playerEntity.xRotO, (float)playerEntity.getXRot());
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)playerEntity);
        if (render instanceof LivingEntityRenderer && (model = (livingEntityRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)model;
            MalumModels.SCARF.copyFromDefault(humanoidModel);
        }
        MalumModels.SCARF.setupAnim((Player)playerEntity, playerEntity.walkAnimation.position(), playerEntity.walkAnimation.speed(), (float)playerEntity.tickCount + pticks, netHeadYaw, netHeadPitch);
        MalumModels.SCARF.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 0xFFFFFF);
    }
}

