/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.common.entity.SunderingAnchorProjectileEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.registry.client.MalumRenderTypeTokens;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.rendeertype.ShaderUniformHandler;

public class SunderingAnchorEntityRenderer
extends EntityRenderer<SunderingAnchorProjectileEntity> {
    public final ItemRenderer itemRenderer;

    public SunderingAnchorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public boolean shouldRender(SunderingAnchorProjectileEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(SunderingAnchorProjectileEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) + 90.0f));
        poseStack.mulPose(Axis.ZN.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        ItemStack itemstack = entity.getItem();
        BakedModel model = this.itemRenderer.getModel(itemstack, entity.level(), null, 1);
        this.itemRenderer.render(itemstack, itemstack.getItem() instanceof MalumScytheItem ? ItemDisplayContext.NONE : ItemDisplayContext.FIXED, false, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        float delta = entity.getVisualEffectScalar();
        float scale = delta * 0.7f;
        float alpha = Mth.clamp((float)(delta * 0.4f), (float)0.0f, (float)1.0f);
        LodestoneRenderType additive = LodestoneRenderTypes.ADDITIVE_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL);
        LodestoneRenderType transparent = LodestoneRenderTypes.TRANSPARENT_TWO_SIDED_TEXTURE_TRIANGLE.apply(MalumRenderTypeTokens.CONCENTRATED_TRAIL, ShaderUniformHandler.LUMITRANSPARENT);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType((RenderType)additive);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.trailPointBuilder, (Entity)entity, MalumSpiritTypes.EARTHEN_SPIRIT, scale * 1.2f, alpha * 0.4f, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.spinningTrailPointBuilder, (Entity)entity, MalumSpiritTypes.EARTHEN_SPIRIT, scale * 2.0f, alpha, partialTicks);
        builder.setRenderType((RenderType)transparent);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.trailPointBuilder, (Entity)entity, MalumSpiritTypes.AERIAL_SPIRIT, scale * 0.6f, alpha * 0.3f, partialTicks);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.spinningTrailPointBuilder, (Entity)entity, MalumSpiritTypes.AERIAL_SPIRIT, scale, alpha, partialTicks);
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(SunderingAnchorProjectileEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

