/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.renderer.entity.bolt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.client.RenderUtils;
import com.sammy.malum.client.renderer.entity.bolt.AbstractBoltEntityRenderer;
import com.sammy.malum.common.entity.bolt.EntropicFlameBoltEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class EntropicFlameBoltEntityRenderer
extends AbstractBoltEntityRenderer<EntropicFlameBoltEntity> {
    public EntropicFlameBoltEntityRenderer(EntityRendererProvider.Context context) {
        super(context, EthericNitrateEntity.AURIC_YELLOW, EthericNitrateEntity.AURIC_RED);
    }

    @Override
    public Color getPrimaryColor(int trailIndex) {
        if (trailIndex == 2) {
            return MalumSpiritTypes.SACRED_SPIRIT.getPrimaryColor();
        }
        if (trailIndex == 0) {
            return ColorHelper.darker((Color)MalumSpiritTypes.EARTHEN_SPIRIT.getPrimaryColor(), (int)2);
        }
        return super.getPrimaryColor(trailIndex);
    }

    @Override
    public Color getSecondaryColor(int trailIndex) {
        if (trailIndex == 2) {
            return MalumSpiritTypes.SACRED_SPIRIT.getSecondaryColor();
        }
        if (trailIndex == 0) {
            return ColorHelper.darker((Color)MalumSpiritTypes.EARTHEN_SPIRIT.getSecondaryColor(), (int)2);
        }
        return super.getSecondaryColor(trailIndex);
    }

    @Override
    public void render(EntropicFlameBoltEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (entity.spawnDelay > 0) {
            return;
        }
        float delta = entity.getVisualEffectScalar();
        float scale = delta * this.getScaleMultiplier();
        float alpha = Mth.clamp((float)(delta * this.getAlphaMultiplier() * 0.5f), (float)0.0f, (float)1.0f);
        VFXBuilders.WorldVFXBuilder builder = VFXBuilders.createWorld().setRenderType(this.getTrailRenderType(true));
        Color aqueousPrimaryColor = MalumSpiritTypes.AQUEOUS_SPIRIT.getPrimaryColor();
        Color darkerPrimary = ColorHelper.darker((Color)aqueousPrimaryColor, (int)2);
        Color aqueousSecondaryColor = MalumSpiritTypes.EARTHEN_SPIRIT.getSecondaryColor();
        Color darkerSecondary = ColorHelper.darker((Color)aqueousSecondaryColor, (int)2);
        RenderUtils.renderEntityTrail(poseStack, builder, entity.secondarySpinningTrailPointBuilder, (Entity)entity, darkerPrimary, darkerSecondary, scale * 2.0f, alpha, partialTicks);
        builder.setRenderType(this.getTrailRenderType(false));
        RenderUtils.renderEntityTrail(poseStack, builder, entity.secondarySpinningTrailPointBuilder, (Entity)entity, aqueousPrimaryColor, aqueousSecondaryColor, scale, alpha, partialTicks);
        super.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }
}

