/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.client.MalumScreenParticles;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;

public class SpiritRiteRecipePage
extends BookPage {
    private static final ScreenParticleHolder RITE_PARTICLES = new ScreenParticleHolder();
    private final TotemicRiteType riteType;

    public SpiritRiteRecipePage(TotemicRiteType riteType) {
        super(MalumMod.malumPath("textures/gui/book/pages/spirit_rite_recipe_page.png"));
        this.riteType = riteType;
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        List<MalumSpiritType> spirits = this.riteType.spirits;
        Minecraft minecraft = Minecraft.getInstance();
        RandomSource rand = minecraft.level.random;
        PoseStack poseStack = guiGraphics.pose();
        if (!isRepeat) {
            if (ScreenParticleHandler.canSpawnParticles) {
                RITE_PARTICLES.tick();
            }
            ScreenParticleHandler.renderParticles((ScreenParticleHolder)RITE_PARTICLES);
        }
        int riteStartX = left + 63;
        int riteStartY = top + 118;
        for (int i = 0; i < spirits.size(); ++i) {
            int y = riteStartY - 20 * i;
            MalumSpiritType spiritType = spirits.get(i);
            ResourceLocation spiritTexture = spiritType.getTotemGlowTexture();
            ItemStack stack = spirits.get(i).getSpiritShard().getDefaultInstance();
            ArcanaCodexHelper.renderRiteIcon(spiritTexture, poseStack, spiritType, this.isCorrupted(), 0.25f, riteStartX, y);
            if (screen.isHovering(mouseX, mouseY, riteStartX, y, 16, 16)) {
                guiGraphics.renderComponentTooltip(minecraft.font, Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)stack), mouseX, mouseY);
            }
            if (!ScreenParticleHandler.canSpawnParticles || minecraft.level.getGameTime() % 6L != 0L) continue;
            int x = riteStartX + 8;
            float xOffset = 25.0f;
            float yMotion = RandomHelper.randomBetween((RandomSource)rand, (float)-0.05f, (float)-0.3f);
            int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)60, (int)120);
            ScreenParticleBuilder.create(MalumScreenParticles.LIGHT_SPEC_SMALL, (ScreenParticleHolder)RITE_PARTICLES).setTransparencyData(GenericParticleData.create((float)0.04f, (float)0.4f, (float)0.0f).setEasing(Easing.CUBIC_OUT, Easing.SINE_IN_OUT).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)rand, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.1f, (float)0.2f), (float)0.0f).randomSpinOffset(rand).setEasing(Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)rand, (float)0.8f, (float)2.4f), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setColorData(spiritType.createColorData().setCoefficient(0.25f).build()).setLifetime(lifetime).setMotion(0.0, (double)yMotion).spawn((double)((float)x - xOffset), (double)(y + 8 + 4 * i)).spawn((double)((float)x + xOffset), (double)(y + 8 + 4 * i));
        }
    }

    public boolean isCorrupted() {
        return this.bookEntry.identifier.contains("corrupt");
    }
}

