/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import com.sammy.malum.common.recipe.SpiritTransmutationRecipe;
import com.sammy.malum.registry.client.MalumScreenParticles;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.handlers.screenparticle.ScreenParticleHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.builder.ScreenParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.screen.ScreenParticleHolder;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class SpiritTransmutationRecipeTreePage
extends BookPage {
    private static final Component BASE = Component.translatable((String)"malum.gui.book.entry.page.info.unchained_transmutation_tree");
    private static final ScreenParticleHolder TRANSMUTATION_PARTICLES = new ScreenParticleHolder();
    private final Component headline;
    private final List<Ingredient> itemTree = new ArrayList<Ingredient>();

    public SpiritTransmutationRecipeTreePage(String headline, Item start) {
        super(MalumMod.malumPath("textures/gui/book/pages/transmutation_recipe_tree_page.png"));
        this.headline = Component.translatable((String)("malum.gui.book.entry.page.headline." + headline));
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            SpiritTransmutationRecipe recipe = (SpiritTransmutationRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get()), (RecipeInput)new SingleRecipeInput(start.getDefaultInstance()));
            while (true) {
                if (recipe == null) {
                    this.itemTree.add(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MalumItems.BLIGHTED_EARTH.get()}));
                    break;
                }
                this.itemTree.add(recipe.ingredient);
                ItemStack output = recipe.output;
                recipe = (SpiritTransmutationRecipe)LodestoneRecipeType.getRecipe((Level)level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get()), (RecipeInput)new SingleRecipeInput(output));
            }
        }
    }

    @Override
    public boolean isValid() {
        return !this.itemTree.isEmpty();
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        ArcanaCodexHelper.renderHeadline(guiGraphics, this.headline, left, top);
        if (!isRepeat) {
            if (ScreenParticleHandler.canSpawnParticles) {
                TRANSMUTATION_PARTICLES.tick();
            }
            ScreenParticleHandler.renderParticles((ScreenParticleHolder)TRANSMUTATION_PARTICLES);
        }
        ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, this.itemTree.getFirst(), left + 63, top + 38, mouseX, mouseY);
        ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, this.itemTree.getLast(), left + 63, top + 142, mouseX, mouseY);
        int leftStart = left + 73 - this.itemTree.size() * 10;
        for (int i = 1; i < this.itemTree.size() - 1; ++i) {
            ArcanaCodexHelper.renderIngredient((AbstractMalumScreen)screen, guiGraphics, this.itemTree.get(i), leftStart + i * 20, top + 90, mouseX, mouseY);
        }
        screen.renderLater(() -> {
            if (screen.isHovering(mouseX, mouseY, left + 62, top + 60, 18, 18)) {
                guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, ArcanaCodexHelper.wrapComponent(BASE, 180), mouseX, mouseY);
            }
        });
        int particlesX = left + 25;
        int particlesY = top + 98;
        if (ScreenParticleHandler.canSpawnParticles) {
            ClientLevel level = Minecraft.getInstance().level;
            RandomSource rand = level.random;
            long time = level.getGameTime();
            for (int i = 0; i < 36; ++i) {
                int yOffsetScale = 4 + Mth.floor((float)((float)i / 4.0f));
                float scale = RandomHelper.randomBetween((RandomSource)rand, (float)0.6f, (float)0.9f);
                float spin = RandomHelper.randomBetween((RandomSource)rand, (float)0.2f, (float)0.4f);
                float xTime = (float)((time + (long)(i * 33)) % 240L) / 240.0f;
                float yTime = (float)(time + (long)(i * 27)) % 100.0f / 100.0f;
                double xOffset = 92.0f * xTime;
                double yOffset = Math.sin(yTime * 6.28f) * (double)yOffsetScale;
                ScreenParticleBuilder.create(MalumScreenParticles.LIGHT_SPEC_SMALL, (ScreenParticleHolder)TRANSMUTATION_PARTICLES).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.4f, (float)0.0f).build()).setSpinData(SpinParticleData.create((float)spin).build()).setScaleData(GenericParticleData.create((float)0.0f, (float)scale, (float)0.0f).build()).setColorData(MalumSpiritTypes.ARCANE_SPIRIT.createColorData().setCoefficient(0.75f).build()).setLifetime(i % 2 == 0 ? 20 : 40).setLifeDelay(i % 3 == 0 ? 0 : 4).spawn((double)particlesX + xOffset, (double)particlesY + yOffset);
            }
        }
    }
}

