/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.waveform;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import com.sammy.malum.common.packets.spirit_diode.SpiritDiodeStateUpdatePayload;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.glfw.GLFW;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypes;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.LodestoneBufferWrapper;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class ValueSettingsScreen
extends Screen {
    private static final Function<GuiGraphics, LodestoneBufferWrapper> WRAPPER_FUNCTION = Util.memoize(guiGraphics -> new LodestoneBufferWrapper(LodestoneRenderTypes.ADDITIVE_TEXT, (MultiBufferSource)guiGraphics.bufferSource));
    private static final VFXBuilders.ScreenVFXBuilder VFX_BUILDER = VFXBuilders.createScreen();
    private static final ResourceLocation TEXTURE = MalumMod.malumPath("textures/gui/waveform_configuration.png");
    private static final ResourceLocation DIAL_TEXTURE = MalumMod.malumPath("textures/gui/waveform_configuration_dial.png");
    private static final int FADE_SIZE = 6;
    private static final int BORDER_SIZE = 5;
    private static final int DIAL_SIZE = 64;
    private final BlockPos pos;
    private final int interfaceWidth;
    private final int interfaceHeight;
    private int guiLeft;
    private int guiTop;
    private int xCenter;
    private int yCenter;
    private int dialLeft;
    private int dialTop;
    private int xDialCenter;
    private int yDialCenter;
    private boolean disableMouse;
    private int ticksOpen = 0;
    private SpiritDiodeBlockEntity.TimeIntervalType timeInterval;
    private int oldAngle;
    private int angle;

    public ValueSettingsScreen(SpiritDiodeBlockEntity diode) {
        super(diode.getTitleComponent());
        this.pos = diode.getBlockPos();
        this.angle = diode.frequency;
        this.timeInterval = diode.type;
        this.interfaceWidth = 244;
        this.interfaceHeight = 124;
        this.notifyServer(true);
    }

    protected void init() {
        this.guiLeft = (this.width - this.interfaceWidth) / 2;
        this.guiTop = (this.height - this.interfaceHeight) / 2;
        this.xCenter = this.guiLeft + this.interfaceWidth / 2;
        this.yCenter = this.guiTop + this.interfaceHeight / 2;
        this.dialLeft = this.xCenter - 32;
        this.dialTop = this.guiTop + 20;
        this.xDialCenter = this.dialLeft + 32;
        this.yDialCenter = this.dialTop + 32;
        Window window = this.minecraft.getWindow();
        double x = this.minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth();
        double y = this.minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight();
        this.updateMousePosition(x, y);
    }

    public void playSound(Holder<SoundEvent> soundEvent) {
        LocalPlayer player = this.minecraft.player;
        ClientLevel level = this.minecraft.level;
        level.playSound((Player)player, player.blockPosition(), (SoundEvent)soundEvent.value(), SoundSource.BLOCKS, 0.8f, RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.9f, (float)1.1f));
    }

    public void tick() {
        super.tick();
        ++this.ticksOpen;
        if (this.oldAngle != this.angle) {
            this.playSound((Holder<SoundEvent>)MalumSoundEvents.SPIRIT_DIODE_TICK);
            this.oldAngle = this.angle;
        }
        if (this.ticksOpen % 20 == 0) {
            this.notifyServer(true);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.disableMouse && ArcanaCodexHelper.isHovering(mouseX, mouseY, this.dialLeft, this.dialTop, 64, 64)) {
            double offsetX = (double)this.xDialCenter - mouseX;
            double offsetY = (double)this.yDialCenter - mouseY;
            this.angle = this.clampAngle(Mth.ceil((double)Math.toDegrees(Math.atan2(offsetX, -offsetY))) + 180);
        }
        this.disableMouse = false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.timeInterval = SpiritDiodeBlockEntity.TimeIntervalType.values()[(this.timeInterval.ordinal() + 1) % 3];
        this.playSound((Holder<SoundEvent>)MalumSoundEvents.SPIRIT_DIODE_LONG_TICK);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.angle = this.clampAngle(this.angle + (scrollY > 0.0 ? 1 : -1));
        this.updateMousePosition(mouseX, mouseY);
        this.disableMouse = true;
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        float delta = Math.min(1.0f, ((float)this.ticksOpen + partialTick) / 5.0f);
        int fadeXStart = (int)((float)this.guiLeft + (float)this.interfaceWidth * (0.5f - delta / 2.0f)) - 6;
        int fadeXEnd = (int)((float)this.guiLeft + (float)this.interfaceWidth * (0.5f + delta / 2.0f)) + 6;
        int fadeYStart = this.guiTop - 6;
        int fadeYEnd = this.guiTop + this.interfaceHeight + 6;
        int a = (int)(128.0f * delta) << 24;
        guiGraphics.fillGradient(fadeXStart, fadeYStart, fadeXEnd, fadeYEnd, 0x101010 | a, 0x101010 | a);
        guiGraphics.drawString(this.font, this.title, this.xCenter - this.font.width((FormattedText)this.title) / 2, this.guiTop, 0xDDDDDD, false);
        for (i = 0; i < 3; ++i) {
            MutableComponent guideText = Component.translatable((String)("malum.waveform_artifice.guide." + i));
            int y = this.guiTop + this.interfaceHeight - 10 * (3 - i);
            guiGraphics.drawString(this.font, (Component)guideText, this.xCenter - this.font.width((FormattedText)guideText) / 2, y, 0xDDDDDD, false);
        }
        this.renderBorderBackground(guiGraphics, this.dialLeft, this.dialTop, 64, 64);
        this.renderDialTexture(guiGraphics, this.dialLeft, this.dialTop);
        for (i = 0; i < 3; ++i) {
            SpiritDiodeBlockEntity.TimeIntervalType type = SpiritDiodeBlockEntity.TimeIntervalType.values()[i];
            this.renderIntervalDisplay(guiGraphics, type.getText(), this.dialLeft - 5, this.dialTop + 13 * i, type.equals((Object)this.timeInterval), partialTick);
        }
        this.renderBorder(guiGraphics, this.dialLeft, this.dialTop, 64, 64);
        MutableComponent text = Component.literal((String)("" + this.angle));
        float f = (float)this.xDialCenter + 0.5f - (float)this.font.width((FormattedText)text) / 2.0f;
        float f2 = (float)this.yDialCenter + 0.5f;
        Objects.requireNonNull(this.font);
        this.renderText(guiGraphics, (Component)text, f, f2 - 9.0f / 2.0f, true, partialTick);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int a = (int)(80.0f * Math.min(1.0f, ((float)this.ticksOpen + pPartialTick) / 20.0f)) << 24;
        graphics.fillGradient(0, 0, this.width, this.height, 0x101010 | a, 0x101010 | a);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyUse.matches(pKeyCode, pScanCode)) {
            this.onClose();
            return true;
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.minecraft.options.keyUse.matchesMouse(pButton)) {
            this.onClose();
            return true;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public void onClose() {
        this.notifyServer(false);
        super.onClose();
    }

    public int clampAngle(int angle) {
        int newAngle = angle;
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344)) {
            newAngle = this.oldAngle > angle ? Mth.floor((float)((float)angle / 10.0f)) * 10 : Mth.ceil((float)((float)angle / 10.0f)) * 10;
        }
        if (newAngle > 360) {
            newAngle -= 360;
        } else if (newAngle < 1) {
            newAngle += 360;
        }
        return newAngle;
    }

    protected void notifyServer(boolean isOpen) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SpiritDiodeStateUpdatePayload(this.pos, isOpen, this.timeInterval, this.angle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateMousePosition(double mouseX, double mouseY) {
        double distance = 28.8f;
        double rad = Math.toRadians(-this.angle + 180);
        double newMouseX = (double)this.xDialCenter + Math.sin(rad) * distance;
        double newMouseY = (double)this.yDialCenter + Math.cos(rad) * distance;
        this.setCursor(newMouseX, newMouseY);
    }

    private void setCursor(double mouseX, double mouseY) {
        double guiScale = this.minecraft.getWindow().getGuiScale();
        GLFW.glfwSetCursorPos((long)this.minecraft.getWindow().getWindow(), (double)(mouseX * guiScale), (double)(mouseY * guiScale));
    }

    public void renderBorderBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        int startX = x - 5;
        int startY = y - 5;
        int endX = x + width;
        int endY = y + height;
        graphics.fillGradient(startX + 1, startY + 1, endX + 5 - 1, endY + 5 - 1, 0, -15793402, -15068396);
    }

    public void renderIntervalDisplay(GuiGraphics graphics, Component text, int x, int y, boolean powered, float pPartialTick) {
        int offset = powered ? 7 : 5;
        this.renderTexture(graphics, x - offset, y, powered ? 0 : 7, 16, 7, 12);
        this.renderText(graphics, text, x - this.font.width((FormattedText)text) - offset, (float)y + 1.5f, powered, pPartialTick);
    }

    public void renderBorder(GuiGraphics graphics, int x, int y, int width, int height) {
        int startX = x - 5;
        int startY = y - 5;
        int endX = x + width;
        int endY = y + height;
        this.renderTexture(graphics, startX, startY, 0, 0, 5, 5);
        this.renderTexture(graphics, endX, startY, 9, 0, 5, 5);
        this.renderTexture(graphics, endX, endY, 9, 9, 5, 5);
        this.renderTexture(graphics, startX, endY, 0, 9, 5, 5);
        this.renderTexture(graphics, startX + 5, startY, 6, 0, endX - startX - 5, 4, 2, 4);
        this.renderTexture(graphics, startX + 5, endY + 1, 6, 10, endX - startX - 5, 4, 2, 4);
        this.renderTexture(graphics, startX, startY + 5, 0, 6, 4, endY - startY - 5, 4, 2);
        this.renderTexture(graphics, endX + 1, startY + 5, 10, 6, 4, endY - startY - 5, 4, 2);
    }

    public void renderTexture(GuiGraphics graphics, int x, int y, int u, int v, int width, int height) {
        ArcanaCodexHelper.renderTexture(TEXTURE, graphics.pose(), VFX_BUILDER, (float)x, (float)y, (float)u, (float)v, width, height, 32, 32);
    }

    public void renderTexture(GuiGraphics graphics, int x, int y, int u, int v, int xCoverage, int yCoverage, int width, int height) {
        ArcanaCodexHelper.renderTexture(TEXTURE, graphics.pose(), VFX_BUILDER, x, y, u, v, xCoverage, yCoverage, width, height, 32, 32);
    }

    public void renderDialTexture(GuiGraphics graphics, int x, int y) {
        ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getInstance().get();
        shaderInstance.safeGetUniform("YFrequency").set(10.0f);
        shaderInstance.safeGetUniform("XFrequency").set(10.0f);
        shaderInstance.safeGetUniform("Speed").set(1000.0f);
        shaderInstance.safeGetUniform("Intensity").set(100.0f);
        shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f(-1.0f, 2.0f, -1.0f, 2.0f));
        Supplier<ShaderInstance> shaderInstanceSupplier = () -> shaderInstance;
        VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader(shaderInstanceSupplier).setAlpha(0.9f).setColor(0.7f, 0.1f, 0.1f).setShader(() -> shaderInstance);
        RenderSystem.blendFunc((int)770, (int)1);
        this.renderDialTexture(graphics, builder, x, y);
        builder.setAlpha(0.2f);
        shaderInstance.safeGetUniform("Speed").set(2000.0f);
        this.renderDialTexture(graphics, builder, x - 1, y);
        this.renderDialTexture(graphics, builder, x + 1, y);
        this.renderDialTexture(graphics, builder, x, y - 1);
        this.renderDialTexture(graphics, builder, x, y + 1);
        shaderInstance.setUniformDefaults();
        RenderSystem.defaultBlendFunc();
    }

    private void renderText(GuiGraphics guiGraphics, Component component, float x, float y, boolean isPowered, float partialTick) {
        String text = component.getString();
        Font font = this.minecraft.font;
        guiGraphics.drawString(font, text, x - 1.0f, y, -2144204278, false);
        guiGraphics.drawString(font, text, x + 1.0f, y, 1345456650, false);
        guiGraphics.drawString(font, text, x, y - 1.0f, 1352865816, false);
        guiGraphics.drawString(font, text, x, y + 1.0f, 1613892106, false);
        guiGraphics.drawString(font, text, x, y, 10688536, false);
        if (isPowered) {
            float gameTime = (float)this.minecraft.level.getGameTime() + partialTick;
            int alpha = Mth.floor((float)(255.0f * (0.4f + Mth.abs((float)(0.3f * Mth.sin((float)(gameTime / 20.0f % 6.28f)))))));
            int base = alpha << 24 | 0xE61919;
            int dim = base & 0xFFFFFF | alpha / 3 << 24;
            int dimmer = base & 0xFFFFFF | alpha / 6 << 24;
            LodestoneBufferWrapper buffer = WRAPPER_FUNCTION.apply(guiGraphics);
            Matrix4f pose = guiGraphics.pose().last().pose();
            RenderSystem.enableBlend();
            float offsetMultiplier = Mth.sin((float)(gameTime / 10.0f % 6.28f));
            float xOffset = 1.25f * offsetMultiplier;
            float yOffset = 2.0f * offsetMultiplier;
            font.drawInBatch(text, x, y, base, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x + 1.0f, y, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x - 1.0f, y, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y + 1.0f, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y - 1.0f, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x + xOffset, y, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x - xOffset, y, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y + yOffset, dim, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            font.drawInBatch(text, x, y - yOffset, dimmer, false, pose, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.isBidirectional());
            RenderSystem.defaultBlendFunc();
        }
    }

    public void renderDialTexture(GuiGraphics graphics, VFXBuilders.ScreenVFXBuilder builder, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        builder.setShaderTexture(DIAL_TEXTURE).setPositionWithWidth((float)x, (float)y, 64.0f, 64.0f).blit(graphics.pose());
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }
}

