/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.blight;

import com.mojang.serialization.MapCodec;
import com.sammy.malum.common.block.blight.BlightedEarthBlock;
import com.sammy.malum.registry.common.MalumTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;

public class BlightedPlantBlock
extends BushBlock
implements BonemealableBlock,
IShearable {
    public static final MapCodec<BlightedPlantBlock> CODEC = BlightedPlantBlock.simpleCodec(BlightedPlantBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public BlightedPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlightedEarthBlock blightedEarthBlock;
        BlockPos below = pPos.below();
        BlockState state = pLevel.getBlockState(below);
        Block block = state.getBlock();
        return block instanceof BlightedEarthBlock && (blightedEarthBlock = (BlightedEarthBlock)block).isBonemealSuccess(pLevel, pRandom, below, state);
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos below = pPos.below();
        BlockState state = pLevel.getBlockState(below);
        Block block = state.getBlock();
        if (block instanceof BlightedEarthBlock) {
            BlightedEarthBlock blightedEarthBlock = (BlightedEarthBlock)block;
            blightedEarthBlock.performBonemeal(pLevel, pRandom, below, state);
        }
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (pState.is(MalumTags.BlockTags.BLIGHT_PLACEABLE_ON)) {
            return true;
        }
        return super.mayPlaceOn(pState, pLevel, pPos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }
}

