/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.packets.spirit_diode.SpiritDiodeVisualUpdatePayload;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectType;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class SpiritDiodeBlockEntity
extends LodestoneBlockEntity {
    public TimeIntervalType type = TimeIntervalType.REDSTONE_TICKS;
    public int frequency = 20;
    public int outputSignal;
    public int inputSignal;
    public int closeDelay;
    public long visualStartTime;
    public int visualTransitionDuration;
    public int visualTransitionStart;
    public int visualTransitionEnd;

    public SpiritDiodeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemInteractionResult onUseWithItem(Player pPlayer, ItemStack pStack, InteractionHand pHand) {
        if (pPlayer.isCrouching() && pStack.is(MalumTags.ItemTags.IS_REDSTONE_TOOL)) {
            this.level.setBlock(this.getBlockPos(), this.getBlockState().rotate((LevelAccessor)this.level, this.getBlockPos(), Rotation.CLOCKWISE_90), 3);
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)MalumSoundEvents.SPIRIT_DIODE_TICK.get(), SoundSource.BLOCKS, 0.8f, RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.9f, (float)1.1f));
            return ItemInteractionResult.SUCCESS;
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.frequency = pTag.getInt("frequency");
        this.type = TimeIntervalType.valueOf(pTag.getString("type"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("frequency", this.frequency);
        tag.putString("type", this.type.name());
    }

    public void tick() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.closeDelay > 0) {
                --this.closeDelay;
                if (this.closeDelay == 0) {
                    this.toggleState(false, this.type, this.frequency);
                }
            }
        }
    }

    public void toggleState(boolean newValue, TimeIntervalType type, int frequency) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean value = (Boolean)this.getBlockState().getValue((Property)SpiritDiodeBlock.OPEN);
            if (value != newValue) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SpiritDiodeBlock.OPEN, (Comparable)Boolean.valueOf(!value)), 3);
                this.level.playSound(null, this.getBlockPos(), value ? (SoundEvent)MalumSoundEvents.SPIRIT_DIODE_CLOSE.get() : (SoundEvent)MalumSoundEvents.SPIRIT_DIODE_OPEN.get(), SoundSource.BLOCKS, 0.8f, RandomHelper.randomBetween((RandomSource)this.level.getRandom(), (float)0.9f, (float)1.1f));
                MalumNetworkedParticleEffectType particleEffect = value ? MalumParticleEffectTypes.SPIRIT_DIODE_CLOSE : MalumParticleEffectTypes.SPIRIT_DIODE_OPEN;
                particleEffect.createEffect().at(this.worldPosition.getCenter().add(0.0, value ? 0.0 : 0.5, 0.0)).color(ColorParticleData.create((Color)new Color(170, 15, 1), (Color)new Color(129, 12, 0)).build()).spawn(serverLevel);
                this.type = type;
                this.frequency = frequency;
                BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.getBlockPos());
            }
            this.closeDelay = newValue ? 100 : 0;
        }
    }

    public Component getTitleComponent() {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock());
        return Component.translatable((String)("malum.waveform_artifice." + id.getPath()));
    }

    public int getAdjustedFrequency() {
        return this.frequency * this.type.timeScale;
    }

    public int getOutputSignal() {
        return Mth.clamp((int)this.outputSignal, (int)0, (int)15);
    }

    public void updateVisuals(int outputSignal, int inputSignal, boolean isPowering) {
        this.outputSignal = outputSignal;
        this.inputSignal = inputSignal;
        this.visualStartTime = this.getLevel().getGameTime();
        this.visualTransitionDuration = this.getAdjustedFrequency();
        this.visualTransitionStart = isPowering ? 0 : 1;
        this.visualTransitionEnd = 1 - this.visualTransitionStart;
    }

    public void updateAnimation(ServerLevel serverLevel, BlockPos pos, int inputSignal) {
        int outputSignal = this.getOutputSignal();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new SpiritDiodeVisualUpdatePayload(pos, outputSignal, inputSignal, outputSignal == 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static enum TimeIntervalType {
        REDSTONE_TICKS(0, 2),
        SECONDS(1, 20),
        MINUTES(2, 1200);

        final int id;
        final int timeScale;

        private TimeIntervalType(int id, int timeScale) {
            this.id = id;
            this.timeScale = timeScale;
        }

        public String getName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public Component getText() {
            return Component.translatable((String)this.getLangKey());
        }

        public String getLangKey() {
            return "malum.waveform_artifice." + this.getName();
        }
    }
}

