/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone.wavebanker;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.redstone.wavebanker.WaveBankerBlockEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WaveBankerBlock
extends SpiritDiodeBlock<WaveBankerBlockEntity> {
    public WaveBankerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean processUpdate(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int signal) {
        int previousSignal = diode.outputSignal;
        diode.outputSignal = signal;
        if (previousSignal > diode.outputSignal) {
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.WAVEBANKER_STORE.get(), SoundSource.BLOCKS, 0.3f, 1.2f);
            this.emitRedstoneParticles(level, pos);
        }
        this.updateState(level, pos, state, diode);
        return false;
    }

    @Override
    public boolean shouldUpdateWhenNeighborChanged(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int newInput) {
        return newInput != diode.outputSignal;
    }

    @Override
    public int redstoneTicksUntilUpdate(Level level, BlockPos pos, BlockState state, WaveBankerBlockEntity diode, int newInput) {
        if (newInput < diode.outputSignal) {
            return super.redstoneTicksUntilUpdate(level, pos, state, diode, newInput);
        }
        return 2;
    }
}

