/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.redstone.wavecharger;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.redstone.wavecharger.WaveChargerBlockEntity;
import com.sammy.malum.registry.common.MalumSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WaveChargerBlock
extends SpiritDiodeBlock<WaveChargerBlockEntity> {
    public WaveChargerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean processUpdate(Level level, BlockPos pos, BlockState state, WaveChargerBlockEntity diode, int signal) {
        int startingSignal;
        if ((startingSignal = diode.outputSignal--) <= signal) {
            if (startingSignal < signal) {
                ++diode.outputSignal;
            } else {
                return false;
            }
        }
        this.updateState(level, pos, state, diode);
        if (diode.outputSignal == signal) {
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.WAVECHARGER_CHARGE.get(), SoundSource.BLOCKS, 0.3f, signal == 0 ? 0.9f : 1.5f);
            this.emitRedstoneParticles(level, pos);
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldUpdateWhenNeighborChanged(Level level, BlockPos pos, BlockState state, WaveChargerBlockEntity diode, int newInput) {
        return newInput != diode.outputSignal;
    }
}

