/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.repair_pylon;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.MalumSpiritBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonComponentBlock;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonSoundInstance;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.recipe.SpiritRepairRecipe;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.block.MalumBlockEntities;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import com.sammy.malum.visual_effects.RepairPylonParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.pylon.PylonEffectData;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.helpers.NBTHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.blockentity.IItemHandlerSupplier;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;
import team.lodestar.lodestone.systems.recipe.LodestoneRecipeType;

public class RepairPylonCoreBlockEntity
extends MultiBlockCoreEntity
implements IItemHandlerSupplier {
    private static final Vec3 PYLON_ITEM_OFFSET = new Vec3(0.5, 2.5, 0.5);
    private static final int HORIZONTAL_RANGE = 6;
    private static final int VERTICAL_RANGE = 4;
    public static final Supplier<MultiBlockStructure> STRUCTURE = () -> MultiBlockStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)MalumBlocks.REPAIR_PYLON_COMPONENT.get()).defaultBlockState()), new MultiBlockStructure.StructurePiece(0, 2, 0, (BlockState)((Block)MalumBlocks.REPAIR_PYLON_COMPONENT.get()).defaultBlockState().setValue((Property)RepairPylonComponentBlock.TOP, (Comparable)Boolean.valueOf(true)))});
    public static final StringRepresentable.EnumCodec<RepairPylonState> CODEC = StringRepresentable.fromEnum(RepairPylonState::values);
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory spiritInventory;
    public SpiritRepairRecipe recipe;
    public RepairPylonState state = RepairPylonState.IDLE;
    public BlockPos repairTargetPosition;
    public int timer;
    public float spiritAmount;
    public float spiritSpin;
    private final Supplier<IItemHandler> exposedInventory = () -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.spiritInventory});

    public RepairPylonCoreBlockEntity(BlockEntityType<? extends RepairPylonCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
        this.inventory = MalumBlockEntityInventory.singleItemStack((LodestoneBlockEntity)this).onContentsChanged(this::updateRecipe);
        this.spiritInventory = MalumSpiritBlockEntityInventory.spiritStacks((LodestoneBlockEntity)this, 4).onContentsChanged(this::updateRecipe);
    }

    public RepairPylonCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends RepairPylonCoreBlockEntity>)((BlockEntityType)MalumBlockEntities.REPAIR_PYLON.get()), STRUCTURE.get(), pos, state);
    }

    public IItemHandler getInventory(Direction direction) {
        return this.exposedInventory.get();
    }

    protected void saveAdditional(CompoundTag compound, @NotNull HolderLookup.Provider pRegistries) {
        compound.putString("state", this.state.name);
        if (this.spiritAmount != 0.0f) {
            compound.putFloat("spiritAmount", this.spiritAmount);
        }
        if (this.repairTargetPosition != null) {
            compound.put("targetedBlock", (Tag)NBTHelper.saveBlockPos((BlockPos)this.repairTargetPosition));
        }
        if (this.timer != 0) {
            compound.putInt("timer", this.timer);
        }
        this.inventory.save(pRegistries, compound);
        this.spiritInventory.save(pRegistries, compound, "spiritInventory");
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.state = compound.contains("state") ? (RepairPylonState)CODEC.byName(compound.getString("state")) : RepairPylonState.IDLE;
        this.spiritAmount = compound.getFloat("spiritAmount");
        if (compound.contains("targetedBlock")) {
            this.repairTargetPosition = NBTHelper.readBlockPos((CompoundTag)compound.getCompound("targetedBlock"));
        }
        this.timer = compound.getInt("timer");
        this.inventory.load(pRegistries, compound);
        this.spiritInventory.load(pRegistries, compound, "spiritInventory");
        this.loadWithLevel(level -> {
            if (this.updateRecipe() != null) {
                if (this.state.equals((Object)RepairPylonState.IDLE)) {
                    this.setState(RepairPylonState.SEARCHING);
                }
                if (level.isClientSide) {
                    RepairPylonSoundInstance.playSound(this);
                }
            }
        });
        super.loadAdditional(compound, pRegistries);
    }

    public ItemInteractionResult onUse(Player pPlayer, InteractionHand pHand) {
        Level level = pPlayer.level();
        if (!(level instanceof ServerLevel)) {
            return ItemInteractionResult.CONSUME;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (pHand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack spiritStack = this.spiritInventory.interact(serverLevel, pPlayer, pHand);
            if (!spiritStack.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack finishedStack = this.inventory.interact(serverLevel, pPlayer, pHand);
            if (!finishedStack.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return super.onUse(pPlayer, pHand);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.level, this.worldPosition);
        this.spiritInventory.dumpItems(this.level, this.worldPosition);
        super.onBreak(player);
    }

    public void tick() {
        Object accessPoint;
        BlockEntity blockEntity;
        super.tick();
        this.spiritAmount = Math.max(1.0f, Mth.lerp((float)0.1f, (float)this.spiritAmount, (float)this.spiritInventory.getFilledSlotCount()));
        if (this.level.isClientSide) {
            this.spiritSpin += 1.0f;
            Object target = null;
            if (this.repairTargetPosition != null && (blockEntity = this.level.getBlockEntity(this.repairTargetPosition)) instanceof IMalumSpecialItemAccessPoint) {
                target = accessPoint = (IMalumSpecialItemAccessPoint)blockEntity;
            }
            RepairPylonParticleEffects.passiveRepairPylonParticles(this, target);
        }
        if ((accessPoint = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessPoint;
            if (!this.state.equals((Object)RepairPylonState.IDLE) && this.recipe == null) {
                this.setState(RepairPylonState.IDLE);
                return;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    if (this.recipe == null) break;
                    this.setState(RepairPylonState.SEARCHING);
                    break;
                }
                case 1: {
                    ++this.timer;
                    if (this.timer < 40) break;
                    boolean success = this.searchForRepairTarget();
                    if (success) {
                        this.setState(RepairPylonState.CHARGING);
                        break;
                    }
                    this.timer = 0;
                    break;
                }
                case 2: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.timer < 600) break;
                    if (this.repairTargetPosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    blockEntity = this.level.getBlockEntity(this.repairTargetPosition);
                    if (!(blockEntity instanceof IMalumSpecialItemAccessPoint) || !this.isRepairTargetValid(provider = (IMalumSpecialItemAccessPoint)blockEntity)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.beginRepair(serverLevel, provider);
                    break;
                }
                case 3: {
                    IMalumSpecialItemAccessPoint provider;
                    ++this.timer;
                    if (this.timer < 40) break;
                    if (this.repairTargetPosition == null) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    blockEntity = this.level.getBlockEntity(this.repairTargetPosition);
                    if (!(blockEntity instanceof IMalumSpecialItemAccessPoint) || !this.isRepairTargetValid(provider = (IMalumSpecialItemAccessPoint)blockEntity)) {
                        this.setState(RepairPylonState.IDLE);
                        return;
                    }
                    this.completeRepair(serverLevel, provider);
                }
            }
        }
    }

    public boolean searchForRepairTarget() {
        Collection pylonProviders = BlockEntityHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (Level)this.level, (BlockPos)this.worldPosition, (int)6, (int)4, (int)6);
        for (IMalumSpecialItemAccessPoint provider : pylonProviders) {
            boolean success = this.isRepairTargetValid(provider);
            if (!success) continue;
            this.repairTargetPosition = provider.getAccessPointBlockPos();
            return true;
        }
        return false;
    }

    public boolean isRepairTargetValid(IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory inventoryForPylon = provider.getSuppliedInventory();
        ItemStack repairTarget = inventoryForPylon.getStackInSlot(0);
        if (repairTarget.isRepairable() && !repairTarget.isDamaged()) {
            return false;
        }
        return this.updateRecipe(repairTarget) != null;
    }

    public void beginRepair(ServerLevel level, IMalumSpecialItemAccessPoint provider) {
        MalumParticleEffectTypes.REPAIR_PYLON_PREPARES.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpiritIngredients(this.recipe.spirits)).customData(new PylonEffectData(provider.getAccessPointBlockPos())).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.REPAIR_PYLON_REPAIR_START.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        this.setState(RepairPylonState.REPAIRING);
    }

    public void completeRepair(ServerLevel level, IMalumSpecialItemAccessPoint provider) {
        LodestoneBlockEntityInventory suppliedInventory = provider.getSuppliedInventory();
        ItemStack repairTarget = suppliedInventory.getStackInSlot(0);
        ItemStack repairMaterial = this.inventory.getStackInSlot(0);
        repairMaterial.shrink(this.recipe.repairMaterial.count());
        block0: for (SpiritIngredient spirit : this.recipe.spirits) {
            for (int i = 0; i < this.spiritInventory.slotCount; ++i) {
                ItemStack spiritStack = this.spiritInventory.getStackInSlot(i);
                if (!spirit.test(spiritStack)) continue;
                spiritStack.shrink(spirit.getCount());
                continue block0;
            }
        }
        ItemStack result = this.recipe.getResultItem(repairTarget);
        suppliedInventory.setStackInSlot(0, result);
        MalumParticleEffectTypes.REPAIR_PYLON_REPAIRS.createEffect(this.worldPosition).color(MalumNetworkedParticleEffectColorData.fromSpiritIngredients(this.recipe.spirits)).customData(new PylonEffectData(provider.getAccessPointBlockPos())).spawn(level);
        level.playSound(null, this.worldPosition, (SoundEvent)MalumSoundEvents.REPAIR_PYLON_REPAIR_FINISH.get(), SoundSource.BLOCKS, 1.0f, 0.8f);
        this.setState(RepairPylonState.IDLE);
    }

    public void setState(RepairPylonState state) {
        this.state = state;
        this.timer = state.equals((Object)RepairPylonState.SEARCHING) ? 100 : 0;
        BlockStateHelper.updateAndNotifyState((Level)this.level, (BlockPos)this.worldPosition);
    }

    public SpiritRepairRecipe updateRecipe() {
        return this.updateRecipe((SpiritRepairRecipe r) -> r.matches(new SpiritBasedRecipeInput(this.inventory.getStackInSlot(0), (List<ItemStack>)this.spiritInventory.nonEmptyItemStacks), this.level));
    }

    public SpiritRepairRecipe updateRecipe(ItemStack repairTarget) {
        return this.updateRecipe((SpiritRepairRecipe r) -> r.matches(new SpiritBasedRecipeInput(this.inventory.getStackInSlot(0), (List<ItemStack>)this.spiritInventory.nonEmptyItemStacks), repairTarget));
    }

    public SpiritRepairRecipe updateRecipe(Predicate<SpiritRepairRecipe> predicate) {
        this.recipe = (SpiritRepairRecipe)LodestoneRecipeType.findRecipe((Level)this.level, (RecipeType)((RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get()), predicate);
        return this.recipe;
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.getBlockPos();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.getX() + offset.x, (double)blockPos.getY() + offset.y, (double)blockPos.getZ() + offset.z);
    }

    public Vec3 getCentralItemOffset() {
        return PYLON_ITEM_OFFSET;
    }

    public Vec3 getSpiritItemOffset(int slot, float partialTicks) {
        float distance = 0.75f + (float)Math.sin((this.spiritSpin + partialTicks) % 6.28f / 20.0f) * 0.025f;
        float height = 2.75f;
        return VecHelper.rotatingRadialOffset((Vec3)new Vec3(0.5, (double)height, 0.5), (float)distance, (float)slot, (float)this.spiritAmount, (float)(this.spiritSpin + partialTicks), (float)360.0f);
    }

    public static enum RepairPylonState implements StringRepresentable
    {
        IDLE("idle"),
        SEARCHING("searching"),
        CHARGING("active"),
        REPAIRING("repairing");

        final String name;

        private RepairPylonState(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

