/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.common.block.curiosities.weeping_well.VoidConduitBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.block.BlockEntityHelper;

public class WeepingWellData {
    public static final float MAX_REJECTION = 60.0f;
    public static final Codec<WeepingWellData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)Codec.BOOL.fieldOf("isNearWeepingWell").forGetter(h -> h.isNearWeepingWell), (App)Codec.BOOL.fieldOf("isInRejectedState").forGetter(h -> h.isInRejectedState), (App)Codec.INT.fieldOf("voidRejection").forGetter(h -> h.voidRejection), (App)Codec.INT.fieldOf("primordialGoopTimer").forGetter(h -> h.primordialGoopTimer)).apply((Applicative)obj, WeepingWellData::new));
    public boolean isNearWeepingWell;
    public boolean isInRejectedState;
    public int voidRejection;
    public int primordialGoopTimer;

    public WeepingWellData() {
    }

    public WeepingWellData(boolean isNearWeepingWell, boolean isInRejectedState, int voidRejection, int primordialGoopTimer) {
        this.isNearWeepingWell = isNearWeepingWell;
        this.isInRejectedState = isInRejectedState;
        this.voidRejection = voidRejection;
        this.primordialGoopTimer = primordialGoopTimer;
    }

    public void update(LivingEntity living) {
        Level level = living.level();
        if (living instanceof Player && level.getGameTime() % 20L == 0L) {
            this.isNearWeepingWell = WeepingWellData.checkForWeepingWell(living).isPresent();
        }
        if (this.isInGoop()) {
            --this.primordialGoopTimer;
            if ((float)this.voidRejection < 60.0f) {
                ++this.voidRejection;
                if ((float)this.voidRejection == 60.0f) {
                    this.isInRejectedState = true;
                    return;
                }
            }
        }
        if (this.isInRejectedState && this.voidRejection > 0) {
            --this.voidRejection;
            if (this.voidRejection == 0) {
                this.isInRejectedState = false;
            }
        }
        if (!this.isInGoop() && !this.isInRejectedState) {
            this.voidRejection = 0;
        }
    }

    public void setGoopStatus() {
        this.primordialGoopTimer = 2;
    }

    public boolean isInGoop() {
        return this.primordialGoopTimer > 0;
    }

    public boolean wasJustRejected() {
        return this.isInRejectedState && (float)this.voidRejection == 60.0f;
    }

    public static Optional<VoidConduitBlockEntity> checkForWeepingWell(LivingEntity livingEntity) {
        return BlockEntityHelper.getBlockEntitiesStream(VoidConduitBlockEntity.class, (Level)livingEntity.level(), (BlockPos)livingEntity.blockPosition(), (int)8).findFirst();
    }
}

