/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.attachment.soul_data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.packets.SyncGeasDataPayload;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

public class GeasSoulData {
    public static final ResourceLocation GEAS_CURIO_SLOT = MalumMod.malumPath("geas_curio_slot");
    public static final Codec<GeasSoulData> CODEC = RecordCodecBuilder.create(obj -> obj.group((App)GeasEffectType.CODEC.listOf().fieldOf("geasEffects").forGetter(sd -> sd.geasEffectTypes)).apply((Applicative)obj, GeasSoulData::new));
    public static StreamCodec<ByteBuf, GeasSoulData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    private final List<GeasEffectType> geasEffectTypes = new ArrayList<GeasEffectType>();
    private final List<GeasEffect> cachedGeasEffects = new ArrayList<GeasEffect>();
    private final List<ItemStack> cachedGeasStacks = new ArrayList<ItemStack>();
    private boolean isDirty;

    public GeasSoulData() {
    }

    private GeasSoulData(List<GeasEffectType> geasEffectTypes) {
        geasEffectTypes.forEach(this::addGeasEffect);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean removeGeasEffect(GeasEffectType geas) {
        if (this.geasEffectTypes.contains(geas)) {
            this.geasEffectTypes.remove(geas);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean tryAddGeasEffect(LivingEntity target, GeasEffectType geas) {
        AttributeInstance attribute = target.getAttribute(MalumAttributes.GEAS_LIMIT);
        if (attribute == null) {
            return false;
        }
        int limit = Mth.ceil((double)attribute.getValue());
        if (this.geasEffectTypes.size() < limit) {
            return this.addGeasEffect(geas);
        }
        return false;
    }

    public boolean addGeasEffect(GeasEffectType geas) {
        if (this.geasEffectTypes.contains(geas)) {
            return false;
        }
        this.geasEffectTypes.add(geas);
        this.setDirty(true);
        return true;
    }

    public boolean hasGeasEffect(LivingEntity living, Holder<GeasEffectType> type) {
        return this.getGeasEffect(living, type) != null;
    }

    public boolean hasGeasEffect(LivingEntity living, GeasEffectType type) {
        return this.getGeasEffect(living, type) != null;
    }

    public List<ItemStack> getGeasItemStacks(LivingEntity entity) {
        this.updateCaches(entity);
        return this.cachedGeasStacks;
    }

    public GeasEffect getGeasEffect(LivingEntity entity, Holder<GeasEffectType> type) {
        return this.getGeasEffect(entity, (GeasEffectType)type.value());
    }

    public GeasEffect getGeasEffect(LivingEntity entity, GeasEffectType type) {
        if (!this.geasEffectTypes.contains(type)) {
            return null;
        }
        return this.getGeasEffects(entity).get(this.getGeasIndex(type));
    }

    public List<GeasEffect> getGeasEffects(LivingEntity entity) {
        this.updateCaches(entity);
        return this.cachedGeasEffects;
    }

    public int getGeasIndex(GeasEffectType type) {
        return this.geasEffectTypes.indexOf(type);
    }

    public void updateCaches(LivingEntity entity) {
        if (this.isDirty()) {
            this.cachedGeasEffects.forEach(e -> e.removeAttributeModifiers(entity));
            this.cachedGeasEffects.clear();
            this.cachedGeasStacks.clear();
            for (GeasEffectType geas : this.geasEffectTypes) {
                this.cachedGeasEffects.add(geas.createEffect());
                this.cachedGeasStacks.add(geas.createDefaultStack());
            }
            if (!entity.level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncGeasDataPayload(entity.getId(), this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(h -> h.addPermanentSlotModifier("geas", GEAS_CURIO_SLOT, (double)this.geasEffectTypes.size(), AttributeModifier.Operation.ADD_VALUE));
            this.setDirty(false);
        }
    }
}

