/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public final class SoulwovenPouchContentsComponent
implements TooltipComponent {
    public static final SoulwovenPouchContentsComponent EMPTY = new SoulwovenPouchContentsComponent(List.of());
    public static final Codec<SoulwovenPouchContentsComponent> CODEC = ItemStack.CODEC.listOf().xmap(SoulwovenPouchContentsComponent::new, contents -> contents.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, SoulwovenPouchContentsComponent> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(SoulwovenPouchContentsComponent::new, contents -> contents.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    final List<ItemStack> items;
    final Fraction weight;

    SoulwovenPouchContentsComponent(List<ItemStack> items, Fraction weight) {
        this.items = items;
        this.weight = weight;
    }

    public SoulwovenPouchContentsComponent(List<ItemStack> items) {
        this(items, SoulwovenPouchContentsComponent.computeContentWeight(items));
    }

    private static Fraction computeContentWeight(List<ItemStack> content) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemstack : content) {
            fraction = fraction.add(SoulwovenPouchContentsComponent.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
        }
        return fraction;
    }

    static Fraction getWeight(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add(contents.weight());
        }
        int weightMultiplier = stack.is(MalumTags.ItemTags.SOULHUNTERS_TREASURE) ? 8 : 1;
        return Fraction.getFraction((int)1, (int)(stack.getMaxStackSize() * weightMultiplier));
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoulwovenPouchContentsComponent)) return false;
        SoulwovenPouchContentsComponent otherContents = (SoulwovenPouchContentsComponent)other;
        if (!this.weight.equals((Object)otherContents.weight)) return false;
        if (!ItemStack.listMatches(this.items, otherContents.items)) return false;
        return true;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "BundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;

        public Mutable(SoulwovenPouchContentsComponent contents) {
            this.items = new ArrayList<ItemStack>(contents.items);
            this.weight = contents.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack stack) {
            if (stack.isStackable()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack compare = this.items.get(i);
                    if (compare.getCount() >= compare.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)compare, (ItemStack)stack)) continue;
                    return i;
                }
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.weight);
            return Math.max(fraction.divideBy(SoulwovenPouchContentsComponent.getWeight(stack)).intValue(), 0);
        }

        public int tryInsert(ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                int i = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
                if (i == 0) {
                    return 0;
                }
                this.weight = this.weight.add(SoulwovenPouchContentsComponent.getWeight(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.findStackIndex(stack);
                if (j != -1) {
                    ItemStack itemstack = this.items.remove(j);
                    int transferSize = Math.min(i, stack.getMaxStackSize() - itemstack.getCount());
                    this.items.addFirst(itemstack.copyWithCount(itemstack.getCount() + transferSize));
                    stack.shrink(transferSize);
                    if (!stack.isEmpty()) {
                        int remainder = stack.getCount();
                        this.weight = this.weight.add(SoulwovenPouchContentsComponent.getWeight(stack).multiplyBy(Fraction.getFraction((int)remainder, (int)1)));
                        this.items.addFirst(itemstack.copyWithCount(remainder));
                        stack.shrink(remainder);
                    }
                } else {
                    this.items.addFirst(stack.split(i));
                }
                return i;
            }
            return 0;
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack itemstack = slot.getItem();
            int i = this.getMaxAmountToAdd(itemstack);
            return this.tryInsert(slot.safeTake(itemstack.getCount(), i, player));
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack itemstack = this.items.removeFirst().copy();
            this.weight = this.weight.subtract(SoulwovenPouchContentsComponent.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
            return itemstack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public SoulwovenPouchContentsComponent toImmutable() {
            return new SoulwovenPouchContentsComponent(List.copyOf(this.items), this.weight);
        }
    }
}

