/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.data.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record SpiritJarContentsComponent(MalumSpiritType spirit, int count) {
    public static Codec<SpiritJarContentsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MalumSpiritType.CODEC.fieldOf("spirit").forGetter(SpiritJarContentsComponent::spirit), (App)Codec.INT.fieldOf("count").forGetter(SpiritJarContentsComponent::count)).apply((Applicative)instance, SpiritJarContentsComponent::new));
    public static StreamCodec<ByteBuf, SpiritJarContentsComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public ItemStack createStack() {
        return this.createStack(Math.min(this.count, 64));
    }

    public ItemStack createStack(int count) {
        return new ItemStack((ItemLike)this.spirit.getSpiritShard(), count);
    }

    public SpiritJarContentsComponent add(int added) {
        return new SpiritJarContentsComponent(this.spirit, this.count + added);
    }

    public SpiritJarContentsComponent remove(int removed) {
        int amount = Math.max(this.count - removed, 0);
        if (amount == 0) {
            return null;
        }
        return new SpiritJarContentsComponent(this.spirit, amount);
    }
}

