/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.effect.gluttony;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.compability.irons_spellbooks.IronsSpellsCompat;
import com.sammy.malum.core.systems.events.ModifyGluttonyPropertiesEvent;
import com.sammy.malum.registry.common.MalumMobEffects;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import team.lodestar.lodestone.handlers.ItemEventHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;

public class GluttonyEffect
extends MobEffect {
    public GluttonyEffect() {
        super(MobEffectCategory.BENEFICIAL, ColorHelper.getColor((int)88, (int)86, (int)60));
        this.addAttributeModifier((Holder)LodestoneAttributes.MAGIC_PROFICIENCY, MalumMod.malumPath("gluttony"), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        IronsSpellsCompat.addGluttonySpellPower(this);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof Player) {
            Player player = (Player)entityLivingBaseIn;
            player.causeFoodExhaustion(0.005f * (float)(amplifier + 1));
        }
        return true;
    }

    public static void canApplyPotion(MobEffectEvent.Applicable event) {
        Holder<MobEffect> gluttony;
        MobEffectInstance potionEffect = event.getEffectInstance();
        LivingEntity entityLiving = event.getEntity();
        if (potionEffect.getEffect().equals((Object)MobEffects.HUNGER) && entityLiving.hasEffect(gluttony = GluttonyEffect.getGluttonyEffectType(event.getEntity()))) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    public static void removeExistingHunger(MobEffectEvent.Added event) {
        MobEffectInstance potionEffect = event.getEffectInstance();
        if (potionEffect == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Holder<MobEffect> gluttony = GluttonyEffect.getGluttonyEffectType(entity);
        if (potionEffect.getEffect().equals(gluttony) && entity.hasEffect(MobEffects.HUNGER)) {
            entity.removeEffect(MobEffects.HUNGER);
        }
    }

    public static GluttonyEffectProperties applyGluttony(LivingEntity collector, Consumer<GluttonyEffectProperties> gluttonyBuilder) {
        GluttonyEffectProperties properties = GluttonyEffect.getGluttonyEffectProperties(collector, gluttonyBuilder);
        Holder<MobEffect> effectType = properties.getEffectType();
        MobEffectInstance effectInstance = collector.getEffect(effectType);
        if (effectInstance == null) {
            if (properties.getInitialDuration() <= 0) {
                return properties;
            }
            collector.addEffect(new MobEffectInstance(effectType, properties.getInitialDuration(), properties.getInitialAmplifier(), true, true, true));
        } else {
            if (properties.getAmplifierGain() > 0) {
                EntityHelper.amplifyEffect((MobEffectInstance)effectInstance, (LivingEntity)collector, (int)properties.getAmplifierGain(), (int)properties.getAmplifierLimit());
            }
            if (properties.getDurationGain() > 0) {
                EntityHelper.extendEffect((MobEffectInstance)effectInstance, (LivingEntity)collector, (int)properties.getDurationGain(), (int)properties.getDurationLimit());
            }
        }
        return properties;
    }

    public static Holder<MobEffect> getGluttonyEffectType(LivingEntity collector) {
        GluttonyEffectProperties properties = GluttonyEffect.getGluttonyEffectProperties(collector, b -> {});
        return properties.effectType;
    }

    public static GluttonyEffectProperties getGluttonyEffectProperties(LivingEntity collector, Consumer<GluttonyEffectProperties> gluttonyBuilder) {
        GluttonyEffectProperties properties = GluttonyEffect.createGluttony();
        gluttonyBuilder.accept(properties);
        ModifyGluttonyPropertiesEvent event = new ModifyGluttonyPropertiesEvent(collector, properties);
        ItemEventHandler.getEventResponders((LivingEntity)collector).forEach(lookup -> lookup.run(IMalumEventResponder.class, (eventResponderItem, stack) -> eventResponderItem.modifyGluttonyPropertiesEvent(event, collector)));
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getProperties();
    }

    public static GluttonyEffectProperties createGluttony() {
        return new GluttonyEffectProperties();
    }

    public static final class GluttonyEffectProperties {
        private Holder<MobEffect> effectType = MalumMobEffects.GLUTTONY;
        private int initialDuration;
        private int initialAmplifier;
        private int durationGain;
        private int amplifierGain;
        private int durationLimit = -1;
        private int amplifierLimit = -1;

        private GluttonyEffectProperties() {
        }

        public Holder<MobEffect> getEffectType() {
            return this.effectType;
        }

        public void replaceEffectType(Holder<MobEffect> effectType) {
            this.effectType = effectType;
        }

        public int getInitialDuration() {
            return this.initialDuration;
        }

        public int getInitialAmplifier() {
            return this.initialAmplifier;
        }

        public GluttonyEffectProperties scaleInitialDuration(float scalar) {
            this.initialDuration = (int)((float)this.initialDuration * scalar);
            return this;
        }

        public GluttonyEffectProperties scaleInitialAmplifier(float scalar) {
            this.initialAmplifier = (int)((float)this.initialAmplifier * scalar);
            return this;
        }

        public GluttonyEffectProperties setInitialData(int initialDuration, int initialAmplifier) {
            this.initialDuration = initialDuration;
            this.initialAmplifier = initialAmplifier;
            return this;
        }

        public int getDurationGain() {
            return this.durationGain;
        }

        public int getAmplifierGain() {
            return this.amplifierGain;
        }

        public GluttonyEffectProperties scaleDurationGain(float scalar) {
            this.durationGain = (int)((float)this.durationGain * scalar);
            return this;
        }

        public GluttonyEffectProperties scaleAmplifierGain(float scalar) {
            this.amplifierGain = (int)((float)this.amplifierGain * scalar);
            return this;
        }

        public GluttonyEffectProperties setStackingData(int durationGain, int amplifierGain) {
            this.durationGain = durationGain;
            this.amplifierGain = amplifierGain;
            return this;
        }

        public int getDurationLimit() {
            return this.durationLimit;
        }

        public int getAmplifierLimit() {
            return this.amplifierLimit;
        }

        public GluttonyEffectProperties scaleDurationLimit(float scalar) {
            this.durationLimit = (int)((float)this.durationLimit * scalar);
            return this;
        }

        public GluttonyEffectProperties scaleAmplifierLimit(float scalar) {
            this.amplifierLimit = (int)((float)this.amplifierLimit * scalar);
            return this;
        }

        public GluttonyEffectProperties setLimitData(int durationLimit, int amplifierLimit) {
            this.durationLimit = durationLimit;
            this.amplifierLimit = amplifierLimit;
            return this;
        }
    }
}

