/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.hidden_blade;

import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class HiddenBladeDelayedImpactEntity
extends ThrowableItemProjectile {
    protected float damage;
    protected float magicDamage;
    public int age;
    public int duration = 25;
    public int enemiesHit;

    public HiddenBladeDelayedImpactEntity(Level level) {
        super((EntityType)MalumEntities.HIDDEN_BLADE_DELAYED_IMPACT.get(), level);
        this.noPhysics = false;
    }

    public HiddenBladeDelayedImpactEntity(Level level, double pX, double pY, double pZ) {
        super((EntityType)MalumEntities.HIDDEN_BLADE_DELAYED_IMPACT.get(), pX, pY, pZ, level);
        this.noPhysics = false;
    }

    public void setData(Entity owner, float damage, float magicDamage, int duration) {
        this.setOwner(owner);
        this.damage = damage;
        this.magicDamage = magicDamage;
        this.duration = duration;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.damage != 0.0f) {
            compound.putFloat("damage", this.damage);
        }
        if (this.magicDamage != 0.0f) {
            compound.putFloat("magicDamage", this.magicDamage);
        }
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (this.duration != 0) {
            compound.putInt("duration", this.duration);
        }
        if (this.enemiesHit != 0) {
            compound.putInt("enemiesHit", this.enemiesHit);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.damage = compound.getFloat("damage");
        this.magicDamage = compound.getFloat("magicDamage");
        this.age = compound.getInt("age");
        this.duration = compound.getInt("duration");
        this.enemiesHit = compound.getInt("enemiesHit");
    }

    protected boolean canHitEntity(Entity pTarget) {
        return !pTarget.equals((Object)this.getOwner()) && super.canHitEntity(pTarget);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Entity target = result.getEntity();
            DamageSource source = DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.HIDDEN_BLADE_PHYSICAL_COUNTER, (Entity)this, (Entity)owner);
            ItemStack heldItem = owner.getMainHandItem();
            Vec3 motion = target.getDeltaMovement();
            owner.setItemInHand(InteractionHand.MAIN_HAND, this.getItem());
            boolean success = target.hurt(source, this.damage);
            if (success && target instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)target;
                if (this.magicDamage > 0.0f && !livingentity.isDeadOrDying()) {
                    livingentity.invulnerableTime = 0;
                    livingentity.hurt(DamageTypeHelper.create((Level)this.level(), MalumDamageTypes.HIDDEN_BLADE_MAGIC_COUNTER, (Entity)this, (Entity)owner), this.magicDamage);
                }
                ++this.enemiesHit;
            }
            owner.setItemInHand(InteractionHand.MAIN_HAND, heldItem);
            target.setDeltaMovement(motion);
            SoundHelper.playSound((Entity)this, (SoundEvent)((SoundEvent)MalumSoundEvents.SCYTHE_CUT.get()), (float)1.0f, (float)(0.9f + this.level().getRandom().nextFloat() * 0.2f));
        }
        super.onHitEntity(result);
    }

    public void tick() {
        ++this.age;
        if (!this.level().isClientSide()) {
            for (Entity target : this.level().getEntities((Entity)this, this.getBoundingBox(), this::canHitEntity)) {
                this.onHitEntity(new EntityHitResult(target));
            }
            if (this.age >= this.duration) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.SOUL_STAINED_STEEL_SCYTHE.get();
    }

    public boolean isNoGravity() {
        return true;
    }

    public float getPickRadius() {
        return 4.0f;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }
}

